/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ConfigurableCombBlockRecipe
implements CraftingRecipe {
    public final Integer count;

    public ConfigurableCombBlockRecipe(Integer count) {
        this.count = count;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput inv, Level level) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() == 1 && stacks.get(0).getItem().equals(ModItems.CONFIGURABLE_COMB_BLOCK.get())) {
            return stacks.get(0).has(ModDataComponents.BEE_TYPE);
        }
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() > 0) {
            ItemStack inStack = stacks.get(0);
            ItemStack outStack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get(), this.count.intValue());
            outStack.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)inStack.get(ModDataComponents.BEE_TYPE)));
            return outStack;
        }
        return ItemStack.EMPTY;
    }

    private List<ItemStack> getItemsInInventory(CraftingInput inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get(), this.count.intValue());
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get()}));
        return nonnulllist;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.CONFIGURABLE_COMB_BLOCK.get();
    }

    public static class Serializer
    implements RecipeSerializer<ConfigurableCombBlockRecipe> {
        private static final MapCodec<ConfigurableCombBlockRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("count").orElse((Object)4).forGetter(recipe -> recipe.count)).apply((Applicative)builder, ConfigurableCombBlockRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConfigurableCombBlockRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ConfigurableCombBlockRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConfigurableCombBlockRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ConfigurableCombBlockRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new ConfigurableCombBlockRecipe(buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading config comb block recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, ConfigurableCombBlockRecipe recipe) {
            try {
                buffer.writeInt(recipe.count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing config comb block recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

