/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.GeneGroup;
import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CombineGeneRecipe
implements CraftingRecipe {
    public CombineGeneRecipe(String name) {
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        int numberOfIngredients = 0;
        GeneValue addedGene = null;
        for (int j = 0; j < inv.size(); ++j) {
            ItemStack itemstack = inv.getItem(j);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem().equals(ModItems.GENE.get())) {
                GeneGroup gene = Gene.getGene(itemstack);
                ++numberOfIngredients;
                if (addedGene == null) {
                    addedGene = GeneValue.byName(gene.value());
                    continue;
                }
                if (addedGene.equals((Object)GeneValue.byName(gene.value())) && Gene.getPurity(itemstack) != 100) continue;
                return false;
            }
            return false;
        }
        return numberOfIngredients > 1;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.size(); ++j) {
            stacks.add(inv.getItem(j));
        }
        return (ItemStack)CombineGeneRecipe.mergeGenes(stacks).getFirst();
    }

    public static Pair<ItemStack, ItemStack> mergeGenes(List<ItemStack> stacks) {
        GeneGroup geneGroup = null;
        int purity = 0;
        for (ItemStack stack : stacks) {
            if (stack.isEmpty() || !stack.getItem().equals(ModItems.GENE.get())) continue;
            geneGroup = Gene.getGene(stack);
            purity += Gene.getPurity(stack).intValue();
        }
        if (geneGroup != null) {
            ItemStack combineStack = Gene.getStack(geneGroup.attribute(), geneGroup.value(), 1, Math.min(100, purity));
            ItemStack leftoverStack = purity > 100 ? Gene.getStack(geneGroup.attribute(), geneGroup.value(), 1, purity - 100) : ItemStack.EMPTY;
            return Pair.of((Object)combineStack, (Object)leftoverStack);
        }
        return Pair.of((Object)ItemStack.EMPTY, (Object)ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return new ItemStack((ItemLike)ModItems.GENE.get());
    }

    @Nonnull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.GENE.get())}));
        list.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.GENE.get())}));
        return list;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.GENE_GENE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CombineGeneRecipe> {
        private static final MapCodec<CombineGeneRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("id").orElse((Object)"").forGetter(recipe -> "")).apply((Applicative)builder, CombineGeneRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CombineGeneRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CombineGeneRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CombineGeneRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static CombineGeneRecipe fromNetwork(@Nonnull FriendlyByteBuf buffer) {
            try {
                return new CombineGeneRecipe("");
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading gene recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull FriendlyByteBuf buffer, CombineGeneRecipe recipe) {
        }
    }
}

