/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.util.Lazy;

public class BeeSpawningRecipe
implements Recipe<RecipeInput> {
    static StreamCodec<RegistryFriendlyByteBuf, HolderSet<Biome>> BIOME_STREAM = ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME);
    public final Ingredient ingredient;
    public final Ingredient spawnItem;
    public final List<Supplier<BeeIngredient>> output;
    public final HolderSet<Biome> biomes;

    public BeeSpawningRecipe(Ingredient ingredient, Ingredient spawnItem, List<Supplier<BeeIngredient>> output, HolderSet<Biome> biomes) {
        this.ingredient = ingredient;
        this.spawnItem = spawnItem;
        this.output = output;
        this.biomes = biomes;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return false;
    }

    public boolean matches(ItemStack nest, ItemStack heldItem, Holder<Biome> biome) {
        boolean anyBiome = false;
        if (this.biomes.size() == 0) {
            anyBiome = true;
        }
        return !(!this.ingredient.test(nest) || !heldItem.equals(ItemStack.EMPTY) && !this.spawnItem.test(heldItem) || !anyBiome && !this.biomes.contains(biome));
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BEE_SPAWNING.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.BEE_SPAWNING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeeSpawningRecipe> {
        private static final MapCodec<BeeSpawningRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Ingredient.CODEC.fieldOf("spawn_item").orElse((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.HONEY_TREAT.get()})).forGetter(recipe -> recipe.spawnItem), (App)BeeIngredient.LIST_CODEC.fieldOf("results").forGetter(recipe -> recipe.output), (App)Biome.LIST_CODEC.fieldOf("biomes").orElse((Object)HolderSet.empty()).forGetter(recipe -> recipe.biomes)).apply((Applicative)builder, BeeSpawningRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BeeSpawningRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BeeSpawningRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BeeSpawningRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BeeSpawningRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                Ingredient spawnItem = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                ArrayList<Supplier<BeeIngredient>> output = new ArrayList<Supplier<BeeIngredient>>();
                IntStream.range(0, buffer.readInt()).forEach(i -> {
                    BeeIngredient ing = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                    output.add((Supplier<BeeIngredient>)Lazy.of(() -> ing));
                });
                return new BeeSpawningRecipe(ingredient, spawnItem, output, (HolderSet<Biome>)((HolderSet)BIOME_STREAM.decode((Object)buffer)));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee spawning recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BeeSpawningRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.spawnItem);
                buffer.writeInt(recipe.output.size());
                for (Supplier<BeeIngredient> beeOutput : recipe.output) {
                    if (beeOutput.get() != null) {
                        beeOutput.get().toNetwork((FriendlyByteBuf)buffer);
                        continue;
                    }
                    ProductiveBees.LOGGER.error("Bee spawning recipe output missing - " + String.valueOf(beeOutput));
                }
                BIOME_STREAM.encode((Object)buffer, recipe.biomes);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee spawning recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

