/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class CombBlockItem
extends BlockItem {
    public CombBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static int getColor(ItemStack stack) {
        CompoundTag nbt;
        ResourceLocation tag = (ResourceLocation)stack.get(ModDataComponents.BEE_TYPE);
        if (tag != null && (nbt = BeeReloadListener.INSTANCE.getData(tag)) != null) {
            return nbt.getInt("primaryColor");
        }
        return -1;
    }

    @Nonnull
    public Component getName(ItemStack stack) {
        CompoundTag nbt;
        ResourceLocation type = (ResourceLocation)stack.get(ModDataComponents.BEE_TYPE);
        if (type != null && (nbt = BeeReloadListener.INSTANCE.getData(type)) != null) {
            String name = Component.translatable((String)("entity.productivebees." + ProductiveBee.getBeeName(type) + "_bee")).getString();
            return Component.translatable((String)"block.productivebees.comb_configurable", (Object[])new Object[]{name.replace(" Bee", "")});
        }
        return super.getName(stack);
    }
}

