/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.IProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBee;
import cy.jdkdigital.productivebees.common.entity.bee.hive.RancherBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.ResinBee;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.ItemConversionRecipe;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.BeeEffect;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.event.BeePollinationCompleteEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ProductiveBee
extends Bee
implements IProductiveBee {
    protected Predicate<Holder<PoiType>> beehiveInterests = poi -> poi.is(PoiTypeTags.BEE_HOME);
    private boolean renderStatic = false;
    protected FollowParentGoal followParentGoal;
    protected BreedGoal breedGoal;
    protected EnterHiveGoal enterHiveGoal;
    private int breedItemCount;

    public ProductiveBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
        this.goalSelector.addGoal(3, (Goal)new ProductiveTemptGoal(this, (PathfinderMob)this, 1.25));
        this.setPathfindingMalus(PathType.TRAPDOOR, -1.0f);
    }

    protected void registerGoals() {
        this.registerBaseGoals();
        this.beePollinateGoal = new PollinateGoal();
        this.goalSelector.addGoal(4, (Goal)this.beePollinateGoal);
        this.goToKnownFlowerGoal = new Bee.BeeGoToKnownFlowerGoal((Bee)this);
        this.goalSelector.addGoal(6, (Goal)this.goToKnownFlowerGoal);
        this.goalSelector.addGoal(7, (Goal)new Bee.BeeGrowCropGoal((Bee)this));
    }

    protected void registerBaseGoals() {
        this.goalSelector.addGoal(0, (Goal)new BeeAttackGoal((PathfinderMob)this, 1.4, true));
        this.enterHiveGoal = new EnterHiveGoal();
        this.goalSelector.addGoal(1, (Goal)this.enterHiveGoal);
        this.breedGoal = new BreedGoal((Animal)this, 1.0, ProductiveBee.class);
        this.goalSelector.addGoal(2, (Goal)this.breedGoal);
        this.followParentGoal = new FollowParentGoal((Animal)this, 1.25);
        this.goalSelector.addGoal(5, (Goal)this.followParentGoal);
        this.goalSelector.addGoal(5, (Goal)new UpdateNestGoal());
        this.goToHiveGoal = new FindNestGoal();
        this.goalSelector.addGoal(5, (Goal)this.goToHiveGoal);
        if (!((Boolean)ProductiveBeesConfig.BEES.disableWanderGoal.get()).booleanValue()) {
            this.goalSelector.addGoal(8, (Goal)new BetterBeeWanderGoal());
        }
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
        if (!this.getBeeName().equals("kamikaz")) {
            this.targetSelector.addGoal(1, (Goal)new Bee.BeeHurtByOtherGoal((Bee)this, (Bee)this).setAlertOthers(new Class[0]));
        }
        this.targetSelector.addGoal(2, (Goal)new Bee.BeeBecomeAngryTargetGoal((Bee)this));
        this.beePollinateGoal = new EmptyPollinateGoal(this);
        this.goToKnownFlowerGoal = new EmptyFindFlowerGoal(this);
    }

    public void tick() {
        List<LivingEntity> entities;
        BeeEffect effect;
        super.tick();
        if (!(this.level().isClientSide || this.tickCount % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.effectTicks.get() != 0 || (effect = this.getBeeEffect()) == null || effect.getEffects().isEmpty() || (entities = this.getBeeType().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"pepto_bismol")) ? this.level().getEntitiesOfClass(LivingEntity.class, new AABB(new BlockPos((Vec3i)this.blockPosition())).inflate(8.0, 6.0, 8.0)) : this.level().getEntitiesOfClass(Player.class, new AABB(new BlockPos((Vec3i)this.blockPosition())).inflate(8.0, 6.0, 8.0)).stream().map(player -> player).collect(Collectors.toList())).isEmpty())) {
            entities.forEach(entity -> {
                for (Map.Entry<Holder<MobEffect>, Integer> entry : effect.getEffects().entrySet()) {
                    entity.addEffect(new MobEffectInstance(entry.getKey(), entry.getValue().intValue()));
                }
            });
        }
        this.checkBelowWorld();
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        ItemStack itemstack;
        boolean isWearingBeeHelmet = false;
        if (livingEntity != null && !(itemstack = livingEntity.getItemBySlot(EquipmentSlot.HEAD)).isEmpty() && itemstack.getItem().equals(ModItems.BEE_NEST_DIAMOND_HELMET.get())) {
            isWearingBeeHelmet = true;
        }
        if (!isWearingBeeHelmet) {
            super.setTarget(livingEntity);
        }
    }

    @Nonnull
    public EntityDimensions getDefaultDimensions(Pose poseIn) {
        return super.getDefaultDimensions(poseIn).scale(this.getSizeModifier());
    }

    public boolean isAngry() {
        return super.isAngry() && !this.getAttributeValue(GeneAttribute.TEMPER).equals((Object)GeneValue.TEMPER_PASSIVE);
    }

    public void setHasNectar(boolean hasNectar) {
        if (!hasNectar || this.getType().is(ModTags.EXTERNAL_CAN_POLLINATE)) {
            this.internalSetHasNectar(hasNectar);
        }
    }

    public void internalSetHasNectar(boolean hasNectar) {
        super.setHasNectar(hasNectar);
    }

    public boolean isFlowerValid(BlockPos pos) {
        return this.isFlowerValid(pos, this::isFlowerBlock, this::isFlowerItem);
    }

    public boolean isFlowerValid(@Nullable BlockPos pos, Predicate<BlockState> validator, Predicate<ItemStack> itemValidator) {
        if (pos == null || !this.level().isLoaded(pos)) {
            return false;
        }
        BlockState flowerBlock = this.level().getBlockState(pos);
        return validator.test(flowerBlock) || flowerBlock.getBlock() instanceof Feeder && ProductiveBee.isValidFeeder(this, this.level().getBlockEntity(pos), validator, itemValidator);
    }

    public List<ItemStack> getBreedingItems() {
        int count = this.getBreedingItemCount();
        return Arrays.stream(this.getBreedingIngredient().getItems()).map(itemStack -> itemStack.copyWithCount(count)).toList();
    }

    public boolean isFood(ItemStack stack) {
        return this.getBreedingIngredient().test(stack);
    }

    public Predicate<Holder<PoiType>> getBeehiveInterests() {
        return this.beehiveInterests;
    }

    public boolean doesHiveAcceptBee(BlockPos pos) {
        BlockEntity blockEntity = this.level().getBlockEntity(pos);
        if (blockEntity instanceof AdvancedBeehiveBlockEntityAbstract) {
            return ((AdvancedBeehiveBlockEntityAbstract)blockEntity).acceptsBee(this);
        }
        return true;
    }

    public static boolean isValidFeeder(Bee bee, BlockEntity tile, Predicate<BlockState> validator, Predicate<ItemStack> itemValidator) {
        AtomicBoolean hasValidBlock = new AtomicBoolean(false);
        if (tile instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)tile;
            for (ItemStack stack : feederBlockEntity.getInventoryItems()) {
                Item slotItem = stack.getItem();
                if (slotItem instanceof BlockItem && validator.test(((BlockItem)slotItem).getBlock().defaultBlockState())) {
                    hasValidBlock.set(true);
                    continue;
                }
                if (itemValidator != null && itemValidator.test(stack)) {
                    hasValidBlock.set(true);
                    continue;
                }
                if (BeeHelper.hasItemConversionRecipe(bee, stack)) {
                    hasValidBlock.set(true);
                    continue;
                }
                if (!BeeHelper.hasNBTChangerRecipe(bee, stack)) continue;
                hasValidBlock.set(true);
            }
            if (!hasValidBlock.get() && ((Boolean)feederBlockEntity.getBlockState().getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && !((Boolean)feederBlockEntity.getBlockState().getValue((Property)Feeder.HONEYLOGGED)).booleanValue()) {
                hasValidBlock.set(validator.test(Blocks.WATER.defaultBlockState()));
            }
        }
        return hasValidBlock.get();
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        super.usePlayerItem(player, hand, stack);
        this.level().broadcastEntityEvent((Entity)this, (byte)13);
        ++this.breedItemCount;
    }

    public void setInLove(@Nullable Player player) {
        if (this.breedItemCount >= this.getBreedingItemCount()) {
            super.setInLove(player);
            this.breedItemCount = 0;
        }
    }

    public boolean wantsToEnterHive() {
        if (this.stayOutOfHiveCountdown <= 0 && !this.beePollinateGoal.isPollinating() && !this.hasStung() && this.getTarget() == null) {
            boolean shouldReturnToHive;
            boolean bl = shouldReturnToHive = this.isTiredOfLookingForNectar() || this.hasNectar();
            if (!shouldReturnToHive && !this.level().dimensionType().hasFixedTime()) {
                shouldReturnToHive = this.level().isNight() && !this.canOperateDuringNight() || this.level().isRaining() && !this.canOperateDuringRain() || this.level().isThundering() && !this.canOperateDuringThunder();
            }
            return shouldReturnToHive && !this.isHiveNearFire();
        }
        return false;
    }

    public void setHasStung(boolean hasStung) {
        if (hasStung && this.getAttributeValue(GeneAttribute.ENDURANCE).equals((Object)GeneValue.ENDURANCE_MEDIUM)) {
            hasStung = this.level().random.nextBoolean();
        }
        if (hasStung && this.getAttributeValue(GeneAttribute.ENDURANCE).equals((Object)GeneValue.ENDURANCE_STRONG)) {
            hasStung = (double)this.level().random.nextFloat() < 0.2;
        }
        super.setHasStung(hasStung);
        if (hasStung && this.getBeeName().equals("kamikaz")) {
            this.hurt(this.level().damageSources().generic(), this.getHealth());
        }
    }

    public ResourceLocation getBeeType() {
        return EntityType.getKey((EntityType)this.getType());
    }

    public String getBeeName() {
        return ProductiveBee.getBeeName(this.getBeeType());
    }

    public static String getBeeName(ResourceLocation beeType) {
        String[] types = beeType.toString().split("[:]");
        String type = types[0];
        if (types.length > 1) {
            type = types[1];
        }
        return type.replace("_bee", "");
    }

    public GeneValue getAttributeValue(GeneAttribute parameter) {
        BeeAttributesHandler attributes = (BeeAttributesHandler)this.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        return attributes.getAttributeValue(parameter);
    }

    public void setAttributeValue(GeneAttribute parameter, GeneValue geneValue) {
        if (parameter.equals((Object)GeneAttribute.ENDURANCE)) {
            // empty if block
        }
        BeeAttributesHandler data = (BeeAttributesHandler)this.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        data.setAttributeValue(parameter, geneValue);
        this.setData(ProductiveBees.ATTRIBUTE_HANDLER, data);
    }

    public Map<GeneAttribute, GeneValue> getBeeAttributes() {
        return ((BeeAttributesHandler)this.getData(ProductiveBees.ATTRIBUTE_HANDLER)).getAttributes();
    }

    public boolean hasBeeAttributes() {
        return this.hasData(ProductiveBees.ATTRIBUTE_HANDLER);
    }

    public void setDefaultAttributes() {
        this.getData(ProductiveBees.ATTRIBUTE_HANDLER);
    }

    @Override
    public boolean canOperateDuringNight() {
        return !this.getAttributeValue(GeneAttribute.BEHAVIOR).equals((Object)GeneValue.BEHAVIOR_DIURNAL);
    }

    @Override
    public boolean canOperateDuringRain() {
        return !this.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).equals((Object)GeneValue.WEATHER_TOLERANCE_NONE);
    }

    @Override
    public boolean canOperateDuringThunder() {
        return this.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE).equals((Object)GeneValue.WEATHER_TOLERANCE_ANY);
    }

    public void setRenderStatic() {
        this.renderStatic = true;
    }

    public boolean getRenderStatic() {
        return this.renderStatic;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.equals(this.level().damageSources().inWall()) || source.equals(this.level().damageSources().sweetBerryBush()) || source.equals(this.level().damageSources().wither()) && this.getBeeType().getPath().contains("dye_bee") || super.isInvulnerableTo(source);
    }

    @Nonnull
    protected PathNavigation createNavigation(@Nonnull Level worldIn) {
        PathNavigation navigator = super.createNavigation(worldIn);
        if (navigator instanceof FlyingPathNavigation) {
            navigator.setCanFloat(false);
            ((FlyingPathNavigation)navigator).setCanPassDoors(false);
        }
        return navigator;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("bee_type", this instanceof SolitaryBee ? "solitary" : "hive");
        tag.putFloat("MaxHealth", this.getMaxHealth());
        tag.putBoolean("HasConverted", this.hasConverted());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.internalSetHasNectar(tag.getBoolean("HasNectar"));
        this.setHasConverted(tag.contains("HasConverted") && tag.getBoolean("HasConverted"));
    }

    public ItemStack getPickedResult(HitResult target) {
        return BeeCreator.getSpawnEgg(this.getBeeType());
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby()) {
            BlockPos pos = this.blockPosition();
            if (this.level().isEmptyBlock(pos)) {
                this.setPos(pos.getX(), pos.getY(), pos.getZ());
            } else if (this.level().isEmptyBlock(pos.below())) {
                pos = pos.below();
                this.setPos(pos.getX(), pos.getY(), pos.getZ());
            }
        }
    }

    @Nullable
    public Bee getBreedOffspring(@Nonnull ServerLevel world, AgeableMob targetEntity) {
        Entity newBee = BeeHelper.getBreedingResult(this, targetEntity, world);
        if (!(newBee instanceof Bee)) {
            return null;
        }
        BeeHelper.setOffspringAttributes((Bee)newBee, this, targetEntity);
        return (Bee)newBee;
    }

    public boolean canMate(@Nonnull Animal otherAnimal) {
        ServerLevel serverLevel;
        Level level;
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof Bee)) {
            return false;
        }
        return this.isInLove() && otherAnimal.isInLove() && ((level = this.level()) instanceof ServerLevel && BeeHelper.getRandomBreedingRecipe(this, (AgeableMob)otherAnimal, serverLevel = (ServerLevel)level) != null || this.canSelfBreed() || !(otherAnimal instanceof ProductiveBee));
    }

    public void postPollinate() {
        if (this.hasNectar() && this.savedFlowerPos != null) {
            BlockState flowerBlockState = this.level().getBlockState(this.savedFlowerPos);
            if (BeeHelper.hasBlockConversionRecipe(this, flowerBlockState)) {
                RecipeHolder<BlockConversionRecipe> recipe = BeeHelper.getBlockConversionRecipe(this, flowerBlockState);
                if (recipe != null) {
                    if (this.level().random.nextFloat() <= ((BlockConversionRecipe)recipe.value()).chance) {
                        this.level().setBlock(this.savedFlowerPos, ((BlockConversionRecipe)recipe.value()).stateTo, 3);
                        this.level().levelEvent(2005, this.savedFlowerPos, 0);
                    }
                    this.setHasConverted(!((BlockConversionRecipe)recipe.value()).pollinates);
                }
            } else {
                BlockEntity blockEntity = this.level().getBlockEntity(this.savedFlowerPos);
                if (blockEntity instanceof FeederBlockEntity) {
                    FeederBlockEntity feederBlockEntity = (FeederBlockEntity)blockEntity;
                    BlockEntity hiveBlockEntity = this.hivePos != null ? this.level().getBlockEntity(this.hivePos) : null;
                    for (ItemStack stack : feederBlockEntity.getInventoryItems()) {
                        BlockItem blockItem;
                        RecipeHolder<BlockConversionRecipe> blockRecipe;
                        Item item = stack.getItem();
                        if (item instanceof BlockItem && (blockRecipe = BeeHelper.getBlockConversionRecipe(this, (blockItem = (BlockItem)item).getBlock().defaultBlockState())) != null && hiveBlockEntity instanceof AdvancedBeehiveBlockEntity) {
                            AdvancedBeehiveBlockEntity beehiveBlockEntity = (AdvancedBeehiveBlockEntity)hiveBlockEntity;
                            if (this.level().random.nextFloat() <= ((BlockConversionRecipe)blockRecipe.value()).chance) {
                                ItemStack output = new ItemStack((ItemLike)((BlockConversionRecipe)blockRecipe.value()).stateTo.getBlock().asItem());
                                if (beehiveBlockEntity.isSim()) {
                                    InventoryHandlerHelper.BlockEntityItemStackHandler itemHandler;
                                    IItemHandlerModifiable iItemHandlerModifiable;
                                    if (!output.equals(ItemStack.EMPTY) && (iItemHandlerModifiable = beehiveBlockEntity.inventoryHandler) instanceof InventoryHandlerHelper.BlockEntityItemStackHandler && (itemHandler = (InventoryHandlerHelper.BlockEntityItemStackHandler)iItemHandlerModifiable).addOutput(output).getCount() == 0) {
                                        stack.shrink(1);
                                    }
                                } else {
                                    Block.popResourceFromFace((Level)this.level(), (BlockPos)feederBlockEntity.getBlockPos(), (Direction)Direction.UP, (ItemStack)output);
                                    stack.shrink(1);
                                }
                            }
                            this.setHasConverted(!((BlockConversionRecipe)blockRecipe.value()).pollinates);
                            return;
                        }
                        RecipeHolder<ItemConversionRecipe> itemRecipe = BeeHelper.getItemConversionRecipe(this, stack);
                        if (itemRecipe == null || !(hiveBlockEntity instanceof AdvancedBeehiveBlockEntity)) continue;
                        AdvancedBeehiveBlockEntity beehiveBlockEntity = (AdvancedBeehiveBlockEntity)hiveBlockEntity;
                        if (this.level().random.nextFloat() <= ((ItemConversionRecipe)itemRecipe.value()).chance) {
                            if (beehiveBlockEntity.isSim()) {
                                InventoryHandlerHelper.BlockEntityItemStackHandler itemHandler;
                                IItemHandlerModifiable iItemHandlerModifiable = beehiveBlockEntity.inventoryHandler;
                                if (iItemHandlerModifiable instanceof InventoryHandlerHelper.BlockEntityItemStackHandler && (itemHandler = (InventoryHandlerHelper.BlockEntityItemStackHandler)iItemHandlerModifiable).addOutput(((ItemConversionRecipe)itemRecipe.value()).output.copy()).getCount() == 0) {
                                    stack.shrink(1);
                                }
                            } else {
                                Block.popResourceFromFace((Level)this.level(), (BlockPos)feederBlockEntity.getBlockPos(), (Direction)Direction.UP, (ItemStack)((ItemConversionRecipe)itemRecipe.value()).output.copy());
                                stack.shrink(1);
                            }
                        }
                        this.setHasConverted(!((ItemConversionRecipe)itemRecipe.value()).pollinates);
                        return;
                    }
                }
            }
            NeoForge.EVENT_BUS.post((Event)new BeePollinationCompleteEvent(this.level(), (Bee)this, this.getSavedFlowerPos()));
        }
    }

    public String getFlowerType() {
        return "block";
    }

    public int getColor(int tintIndex, float tickCount) {
        return -1;
    }

    public boolean isColored() {
        return false;
    }

    public boolean isFlowerBlock(BlockState flowerBlock) {
        return flowerBlock.is(ModTags.DEFAULT_FLOWERING_BLOCK) || BeeHelper.hasBlockConversionRecipe(this, flowerBlock);
    }

    public boolean isFlowerItem(ItemStack flowerItem) {
        BlockItem blockItem;
        Item item = flowerItem.getItem();
        if (item instanceof BlockItem && this.isFlowerBlock((blockItem = (BlockItem)item).getBlock().defaultBlockState())) {
            return true;
        }
        return BeeHelper.hasItemConversionRecipe(this, flowerItem);
    }

    public TagKey<Block> getNestingTag() {
        return BlockTags.BEEHIVES;
    }

    public BeeEffect getBeeEffect() {
        return null;
    }

    public boolean hasConverted() {
        return this.getFlag(16);
    }

    public void setHasConverted(boolean hasConverted) {
        this.setFlag(16, hasConverted);
    }

    public class ProductiveTemptGoal
    extends TemptGoal {
        public ProductiveTemptGoal(ProductiveBee this$0, PathfinderMob entity, double speed) {
            super(entity, speed, (Predicate)Ingredient.of(ModTags.BEE_TEMPT_ITEMS), false);
        }
    }

    public class PollinateGoal
    extends Bee.BeePollinateGoal {
        public Predicate<BlockPos> flowerPredicate;

        public PollinateGoal() {
            super((Bee)ProductiveBee.this);
            this.flowerPredicate = blockPos -> {
                BlockState blockState = ProductiveBee.this.level().getBlockState(blockPos);
                boolean isInterested = false;
                try {
                    if (blockState.getBlock() instanceof Feeder) {
                        isInterested = ProductiveBee.isValidFeeder(ProductiveBee.this, ProductiveBee.this.level().getBlockEntity(blockPos), ProductiveBee.this::isFlowerBlock, ProductiveBee.this::isFlowerItem);
                    } else if (!ProductiveBee.this.getFlowerType().equals("entity_type") && (isInterested = ProductiveBee.this.isFlowerBlock(blockState)) && blockState.is(BlockTags.TALL_FLOWERS) && blockState.getBlock() == Blocks.SUNFLOWER) {
                        isInterested = blockState.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.UPPER;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return isInterested;
            };
        }

        public boolean canBeeUse() {
            if (ProductiveBee.this.remainingCooldownBeforeLocatingNewFlower > 0) {
                return false;
            }
            if (ProductiveBee.this.hasNectar()) {
                return false;
            }
            if (ProductiveBee.this.level().isRaining() && !ProductiveBee.this.canOperateDuringRain()) {
                return false;
            }
            if (ProductiveBee.this.level().isThundering() && !ProductiveBee.this.canOperateDuringThunder()) {
                return false;
            }
            Optional<BlockPos> optional = this.findNearbyFlower();
            if (optional.isPresent()) {
                ProductiveBee.this.savedFlowerPos = optional.get();
                ProductiveBee.this.navigation.moveTo((double)ProductiveBee.this.savedFlowerPos.getX() + 0.5, (double)ProductiveBee.this.savedFlowerPos.getY() + 0.5, (double)ProductiveBee.this.savedFlowerPos.getZ() + 0.5, (double)1.2f);
                return true;
            }
            ProductiveBee.this.remainingCooldownBeforeLocatingNewFlower = 70 + ProductiveBee.this.level().random.nextInt(50);
            return false;
        }

        public boolean canBeeContinueToUse() {
            if (!this.isPollinating()) {
                return false;
            }
            if (!ProductiveBee.this.hasSavedFlowerPos()) {
                return false;
            }
            if (ProductiveBee.this.level().isRaining() && !ProductiveBee.this.canOperateDuringRain()) {
                return false;
            }
            if (ProductiveBee.this.level().isThundering() && !ProductiveBee.this.canOperateDuringThunder()) {
                return false;
            }
            if (this.hasPollinatedLongEnough()) {
                return ProductiveBee.this.random.nextFloat() < 0.2f;
            }
            if (ProductiveBee.this.tickCount % 20 == 0 && !ProductiveBee.this.isFlowerValid(ProductiveBee.this.savedFlowerPos)) {
                ProductiveBee.this.savedFlowerPos = null;
                return false;
            }
            return true;
        }

        public void tick() {
            if (ProductiveBee.this.hasSavedFlowerPos()) {
                super.tick();
            }
        }

        public void stop() {
            super.stop();
            if (this.hasPollinatedLongEnough()) {
                ProductiveBee.this.internalSetHasNectar(true);
            }
            ProductiveBee.this.postPollinate();
        }

        @Nonnull
        public Optional<BlockPos> findNearbyFlower() {
            CompoundTag nbt;
            Optional<BlockPos> entities;
            if (ProductiveBee.this instanceof RancherBee && (entities = this.findEntities(RancherBee.predicate, 5.0)).isPresent()) {
                return entities;
            }
            if (ProductiveBee.this instanceof ResinBee && (entities = this.findEntities(ResinBee.predicate, 5.0)).isPresent()) {
                return entities;
            }
            if (ProductiveBee.this instanceof ConfigurableBee && ProductiveBee.this.getFlowerType().equals("entity_types") && (nbt = ((ConfigurableBee)ProductiveBee.this).getNBTData()) != null && nbt.contains("flowerTag")) {
                TagKey<EntityType<?>> flowerTag = ModTags.getEntityTag(ResourceLocation.parse((String)nbt.getString("flowerTag")));
                Optional<BlockPos> amberBlocks = this.findNearestBlock(pos -> {
                    BlockEntity patt0$temp = ProductiveBee.this.level().getBlockEntity(pos);
                    if (patt0$temp instanceof AmberBlockEntity) {
                        AmberBlockEntity amberBlockEntity = (AmberBlockEntity)patt0$temp;
                        Entity entity = amberBlockEntity.getCachedEntity();
                        return entity != null && entity.getType().is(flowerTag);
                    }
                    return false;
                }, 5.0);
                if (amberBlocks.isPresent()) {
                    return amberBlocks;
                }
                Optional<BlockPos> entityPositions = this.findEntities(entity -> entity instanceof Mob && nbt.getBoolean("inverseFlower") != entity.getType().is(flowerTag), 5.0);
                if (entityPositions.isPresent()) {
                    return entityPositions;
                }
            }
            return this.findNearestBlock(this.flowerPredicate, 5.0);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockPos> predicate, double distance) {
            BlockPos blockpos = ProductiveBee.this.blockPosition();
            BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= distance) {
                int j = 0;
                while ((double)j < distance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutableblockpos.setWithOffset((Vec3i)blockpos, k, i - 1, l);
                            if (blockpos.closerThan((Vec3i)mutableblockpos, distance) && predicate.test((BlockPos)mutableblockpos)) {
                                return Optional.of(mutableblockpos.immutable());
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }

        private Optional<BlockPos> findEntities(Predicate<Entity> predicate, double distance) {
            BlockPos blockpos = ProductiveBee.this.blockPosition();
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            List entities = ProductiveBee.this.level().getEntities((Entity)ProductiveBee.this, new AABB(blockpos).inflate(distance, distance, distance), predicate);
            if (entities.size() > 0) {
                Entity target = (Entity)entities.get(0);
                if (target instanceof PathfinderMob) {
                    PathfinderMob pathfinderMob = (PathfinderMob)target;
                    pathfinderMob.getNavigation().setSpeedModifier(0.0);
                }
                blockpos$mutable.set(target.getX(), target.getY(), target.getZ());
                return Optional.of(blockpos$mutable.immutable());
            }
            return Optional.empty();
        }
    }

    public class BeeAttackGoal
    extends MeleeAttackGoal {
        BeeAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean canUse() {
            return super.canUse() && ProductiveBee.this.isAngry() && !ProductiveBee.this.hasStung();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && ProductiveBee.this.isAngry() && !ProductiveBee.this.hasStung();
        }
    }

    public class EnterHiveGoal
    extends Bee.BeeEnterHiveGoal {
        public EnterHiveGoal() {
            super((Bee)ProductiveBee.this);
        }

        public boolean canBeeUse() {
            BlockEntity blockEntity;
            if (ProductiveBee.this.hasHive() && ProductiveBee.this.wantsToEnterHive() && ProductiveBee.this.hivePos.closerToCenterThan((Position)ProductiveBee.this.position(), 2.0) && (blockEntity = ProductiveBee.this.level().getBlockEntity(ProductiveBee.this.hivePos)) instanceof BeehiveBlockEntity) {
                BeehiveBlockEntity beehiveblockentity = (BeehiveBlockEntity)blockEntity;
                if (!beehiveblockentity.isFull()) {
                    return true;
                }
                ProductiveBee.this.hivePos = null;
            }
            return false;
        }
    }

    public class UpdateNestGoal
    extends Bee.BeeLocateHiveGoal {
        public UpdateNestGoal() {
            super((Bee)ProductiveBee.this);
        }

        public void start() {
            ProductiveBee.this.remainingCooldownBeforeLocatingNewHive = 200;
            List<BlockPos> nearbyNests = this.getNearbyFreeNests();
            if (!nearbyNests.isEmpty()) {
                BlockPos blockPos;
                Iterator<BlockPos> iterator = nearbyNests.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    ProductiveBee.this.goToHiveGoal.clearBlacklist();
                    ProductiveBee.this.hivePos = nearbyNests.get(0);
                    return;
                } while (ProductiveBee.this.goToHiveGoal.isTargetBlacklisted(blockPos = iterator.next()));
                ProductiveBee.this.hivePos = blockPos;
            }
        }

        private List<BlockPos> getNearbyFreeNests() {
            BlockPos pos = ProductiveBee.this.blockPosition();
            PoiManager poiManager = ((ServerLevel)ProductiveBee.this.level()).getPoiManager();
            Stream stream = poiManager.getInRange(ProductiveBee.this.beehiveInterests, pos, 30, PoiManager.Occupancy.ANY);
            return stream.map(PoiRecord::getPos).filter(arg_0 -> ((ProductiveBee)ProductiveBee.this).doesHiveHaveSpace(arg_0)).filter(ProductiveBee.this::doesHiveAcceptBee).sorted(Comparator.comparingDouble(vec -> vec.distSqr((Vec3i)pos))).collect(Collectors.toList());
        }
    }

    public class FindNestGoal
    extends Bee.BeeGoToHiveGoal {
        public FindNestGoal() {
            super((Bee)ProductiveBee.this);
        }

        public boolean canBeeUse() {
            if (!ProductiveBee.this.hasHive()) {
                return false;
            }
            HolderSet.Named nestTag = BuiltInRegistries.BLOCK.getOrCreateTag(ProductiveBee.this.getNestingTag());
            try {
                if (nestTag.size() == 0) {
                    return false;
                }
            }
            catch (Exception e) {
                String bee = ProductiveBee.this.getEncodeId();
                if (ProductiveBee.this instanceof ConfigurableBee) {
                    bee = ProductiveBee.this.getBeeType().toString();
                }
                ProductiveBees.LOGGER.debug("Nesting tag for " + bee + " not found. Looking for " + String.valueOf(nestTag));
            }
            return !ProductiveBee.this.hasRestriction() && ProductiveBee.this.wantsToEnterHive() && !this.isCloseEnough(ProductiveBee.this.hivePos) && ProductiveBee.this.level().getBlockState(ProductiveBee.this.hivePos).is((HolderSet)nestTag);
        }

        private boolean isCloseEnough(BlockPos pos) {
            if (ProductiveBee.this.closerThan(pos, 3)) {
                return true;
            }
            Path path = ProductiveBee.this.navigation.getPath();
            return path != null && path.getTarget().equals((Object)pos) && path.canReach() && path.isDone();
        }

        public void blacklistTarget(BlockPos pos) {
            BlockEntity tileEntity = ProductiveBee.this.level().getBlockEntity(pos);
            TagKey<Block> nestTag = ProductiveBee.this.getNestingTag();
            if (tileEntity != null && tileEntity.getBlockState().is(nestTag)) {
                this.blacklistedTargets.add(pos);
                while (this.blacklistedTargets.size() > 3) {
                    this.blacklistedTargets.remove(0);
                }
            }
        }
    }

    public class BetterBeeWanderGoal
    extends Bee.BeeWanderGoal {
        public BetterBeeWanderGoal() {
            super((Bee)ProductiveBee.this);
        }

        public boolean canUse() {
            return super.canUse() || ProductiveBee.this.hivePos != null && !ProductiveBee.this.closerThan(ProductiveBee.this.hivePos, 22);
        }
    }

    public class EmptyPollinateGoal
    extends PollinateGoal {
        public EmptyPollinateGoal(ProductiveBee this$0) {
        }

        @Override
        public boolean canBeeUse() {
            return false;
        }
    }

    public class EmptyFindFlowerGoal
    extends Bee.BeeGoToKnownFlowerGoal {
        public EmptyFindFlowerGoal(ProductiveBee this$0) {
            super((Bee)this$0);
        }

        public boolean canBeeUse() {
            return false;
        }
    }
}

