/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.crafting.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import java.util.Arrays;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class ComponentIngredient
extends DataComponentIngredient {
    public static final MapCodec<ComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(DataComponentIngredient::items), (App)DataComponentPredicate.CODEC.fieldOf("components").forGetter(DataComponentIngredient::components)).apply((Applicative)builder, ComponentIngredient::new));

    public ComponentIngredient(HolderSet<Item> items, DataComponentPredicate components) {
        super(items, components, false);
    }

    public IngredientType<?> getType() {
        return (IngredientType)ProductiveBees.HONEYCOMB_INGREDIENT_TYPE.get();
    }

    public static Ingredient of(ItemStack stack) {
        DataComponentMap.Builder builder = DataComponentMap.builder();
        if (stack.has(DataComponents.ENTITY_DATA)) {
            builder.set(DataComponents.ENTITY_DATA, (Object)((CustomData)stack.get(DataComponents.ENTITY_DATA)));
        }
        if (stack.has(ModDataComponents.BEE_TYPE)) {
            builder.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)stack.get(ModDataComponents.BEE_TYPE)));
        }
        return ComponentIngredient.of(DataComponentPredicate.allOf((DataComponentMap)builder.build()), new ItemLike[]{stack.getItem()});
    }

    public static Ingredient of(DataComponentPredicate predicate, ItemLike ... items) {
        return ComponentIngredient.of(predicate, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()));
    }

    public static Ingredient of(DataComponentPredicate predicate, HolderSet<Item> items) {
        return new ComponentIngredient(items, predicate).toVanilla();
    }
}

