/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.GeneGroup;
import cy.jdkdigital.productivelib.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivelib.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CentrifugeBlockEntity
extends FluidTankBlockEntity
implements MenuProvider,
UpgradeableBlockEntity,
IRecipeProcessingBlockEntity {
    private RecipeHolder<? extends CentrifugeRecipe> currentRecipe = null;
    public int recipeProgress = 0;
    public int fluidId = 0;
    public int transferCooldown = -1;
    public IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(11, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        public boolean isContainerItem(Item item) {
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean fromAutomation) {
            ItemStack existing;
            if (fromAutomation && !(existing = (ItemStack)this.stacks.get(slot)).isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate, fromAutomation);
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            ItemStack currentStack = this.getStackInSlot(slot);
            if (currentStack.getCount() == currentStack.getMaxStackSize()) {
                return false;
            }
            boolean isProcessableItem = ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)item) || item.getItem().equals(ModItems.GENE_BOTTLE.get()) || item.getItem().equals(ModItems.HONEY_TREAT.get()) || CentrifugeBlockEntity.this.canProcessItemStack(item);
            return isProcessableItem && slot == 1 || !isProcessableItem && !super.isInputSlot(slot);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            Level level = CentrifugeBlockEntity.this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (slot == 1 && this.getStackInSlot(slot).isEmpty()) {
                    CentrifugeBlockEntity.this.recipeProgress = 0;
                    serverLevel.setBlockAndUpdate(CentrifugeBlockEntity.this.getBlockPos(), (BlockState)CentrifugeBlockEntity.this.getBlockState().setValue((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    };
    public FluidTank fluidHandler = new FluidTank(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            CentrifugeBlockEntity.this.fluidId = BuiltInRegistries.FLUID.getId((Object)this.getFluid().getFluid());
            CentrifugeBlockEntity.this.setChanged();
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get(), (Item)LibItems.UPGRADE_ENTITY_FILTER.get()));
    static Map<String, RecipeHolder<CentrifugeRecipe>> recipeMap = new HashMap<String, RecipeHolder<CentrifugeRecipe>>();

    public CentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CENTRIFUGE.get(), pos, state);
    }

    public CentrifugeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public RecipeHolder<? extends TimedRecipeInterface> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime(RecipeHolder<? extends TimedRecipeInterface> recipe) {
        return Math.max((int)((double)(recipe != null ? ((TimedRecipeInterface)recipe.value()).getProcessingTime() : ((Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get()).intValue()) * this.getProcessingTimeModifier()), 5);
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
        return Math.max(0.0, timeUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CentrifugeBlockEntity blockEntity) {
        IItemHandlerModifiable iItemHandlerModifiable = blockEntity.inventoryHandler;
        if (iItemHandlerModifiable instanceof InventoryHandlerHelper.BlockEntityItemStackHandler) {
            InventoryHandlerHelper.BlockEntityItemStackHandler itemStackHandler = (InventoryHandlerHelper.BlockEntityItemStackHandler)iItemHandlerModifiable;
            ItemStack invItem = itemStackHandler.getStackInSlot(1);
            if (!invItem.isEmpty() && blockEntity.canOperate()) {
                RecipeHolder<CentrifugeRecipe> recipe;
                if (((Boolean)state.getValue((Property)Centrifuge.RUNNING)).booleanValue() && --blockEntity.recipeProgress <= 0) {
                    if (invItem.getItem().equals(ModItems.GENE_BOTTLE.get())) {
                        blockEntity.completeGeneProcessing((IItemHandlerModifiable)itemStackHandler, level.random);
                    } else if (invItem.getItem().equals(ModItems.HONEY_TREAT.get())) {
                        blockEntity.completeTreatProcessing((IItemHandlerModifiable)itemStackHandler);
                    } else if (!invItem.isEmpty() && blockEntity.canProcessRecipe(recipe = blockEntity.getRecipe(itemStackHandler), (IItemHandlerModifiable)itemStackHandler)) {
                        blockEntity.completeRecipeProcessing(recipe, (IItemHandlerModifiable)itemStackHandler, level.random);
                    }
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
                    blockEntity.setChanged();
                }
                if (!((Boolean)state.getValue((Property)Centrifuge.RUNNING)).booleanValue()) {
                    if (invItem.getItem().equals(ModItems.GENE_BOTTLE.get())) {
                        blockEntity.recipeProgress = blockEntity.getProcessingTime(null);
                    } else if (invItem.getItem().equals(ModItems.HONEY_TREAT.get())) {
                        blockEntity.recipeProgress = blockEntity.getProcessingTime(null);
                    } else if (!invItem.isEmpty()) {
                        recipe = blockEntity.getRecipe(itemStackHandler);
                        blockEntity.recipeProgress = blockEntity.getProcessingTime(recipe);
                    }
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                    blockEntity.setChanged();
                }
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
            }
            if (((Boolean)ProductiveBeesConfig.GENERAL.centrifugeHopperMode.get()).booleanValue() && --blockEntity.transferCooldown <= 0) {
                blockEntity.transferCooldown = 22;
                blockEntity.suckInItems((ItemStackHandler)itemStackHandler);
            }
        }
        FluidTankBlockEntity.tick((Level)level, (BlockPos)pos, (BlockState)state, (FluidTankBlockEntity)blockEntity);
    }

    public void tickFluidTank(Level level, BlockPos pos, BlockState state, FluidTankBlockEntity blockEntity) {
        IFluidHandler fluidHandler = blockEntity.getFluidHandler();
        FluidStack fluidStack = fluidHandler.getFluidInTank(0);
        if (fluidStack.getAmount() > 0) {
            Direction[] directions;
            for (Direction direction : directions = Direction.values()) {
                int amount;
                IFluidHandler h;
                if (fluidStack.getAmount() <= 0 || (h = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(direction.getOpposite()), null)) == null || (amount = h.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
                amount = h.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    private void suckInItems(ItemStackHandler invHandler) {
        for (ItemEntity itemEntity : this.getCaptureItems()) {
            ItemStack itemStack = itemEntity.getItem();
            if (!this.canProcessItemStack(itemStack) && !itemStack.getItem().equals(ModItems.GENE_BOTTLE.get()) && (!itemStack.getItem().equals(ModItems.HONEY_TREAT.get()) || !HoneyTreat.hasGene(itemStack))) continue;
            CentrifugeBlockEntity.captureItem((IItemHandlerModifiable)invHandler, itemEntity);
        }
    }

    private List<ItemEntity> getCaptureItems() {
        assert (this.level != null);
        return Centrifuge.COLLECTION_AREA_SHAPE.toAabbs().stream().flatMap(blockPos -> this.level.getEntitiesOfClass(ItemEntity.class, blockPos.move((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    private static void captureItem(IItemHandlerModifiable invHandler, ItemEntity itemEntity) {
        ItemStack leftoverStack = invHandler.insertItem(1, itemEntity.getItem(), false);
        if (leftoverStack.isEmpty()) {
            itemEntity.discard();
        } else {
            itemEntity.setItem(leftoverStack);
        }
    }

    protected boolean canOperate() {
        return true;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public boolean canProcessItemStack(ItemStack stack) {
        InventoryHandlerHelper.BlockEntityItemStackHandler inv = new InventoryHandlerHelper.BlockEntityItemStackHandler(2, null);
        inv.setStackInSlot(1, stack);
        boolean isAllowedByFilter = true;
        List filterUpgrades = this.getInstalledUpgrades((Item)LibItems.UPGRADE_ENTITY_FILTER.get());
        if (!filterUpgrades.isEmpty()) {
            isAllowedByFilter = false;
            for (ItemStack filter : filterUpgrades) {
                List entities = (List)filter.getOrDefault(ModDataComponents.ENTITY_TYPE_LIST, new ArrayList());
                block1: for (ResourceLocation beeType : entities) {
                    Supplier<BeeIngredient> allowedBee = BeeIngredientFactory.getIngredient(beeType);
                    if (allowedBee.get() == null) continue;
                    List<ItemStack> produceList = BeeHelper.getBeeProduce(this.level, (Bee)allowedBee.get().getCachedEntity(this.level), false, 1.0);
                    for (ItemStack pStack : produceList) {
                        if (!pStack.getItem().equals(stack.getItem())) continue;
                        isAllowedByFilter = true;
                        continue block1;
                    }
                }
            }
        }
        RecipeHolder<CentrifugeRecipe> recipe = this.getRecipe(inv);
        return isAllowedByFilter && recipe != null;
    }

    protected RecipeHolder<CentrifugeRecipe> getRecipe(InventoryHandlerHelper.BlockEntityItemStackHandler inputHandler) {
        ItemStack input;
        if (recipeMap.size() > 5000) {
            recipeMap.clear();
        }
        if ((input = inputHandler.getStackInSlot(1)).isEmpty() || this.level == null) {
            return null;
        }
        String cacheKey = BuiltInRegistries.ITEM.getKey((Object)input.getItem()).toString() + String.valueOf(!input.getComponents().isEmpty() ? input.getComponents().stream().map(TypedDataComponent::toString).reduce((s, s2) -> s + s2) : "");
        if (!recipeMap.containsKey(cacheKey)) {
            recipeMap.put(cacheKey, BeeHelper.getCentrifugeRecipe(this.level, inputHandler));
        }
        return recipeMap.getOrDefault(cacheKey, null);
    }

    protected boolean canProcessRecipe(@Nullable RecipeHolder<CentrifugeRecipe> recipe, IItemHandlerModifiable invHandler) {
        if (recipe != null) {
            ArrayList outputList = Lists.newArrayList();
            ((CentrifugeRecipe)recipe.value()).getRecipeOutputs().forEach((stack, value) -> {
                ItemStack item = new ItemStack((ItemLike)stack.getItem(), value.max());
                outputList.add(item);
            });
            return ((InventoryHandlerHelper.BlockEntityItemStackHandler)invHandler).canFitStacks((List)outputList);
        }
        return false;
    }

    protected void completeRecipeProcessing(RecipeHolder<CentrifugeRecipe> recipe, IItemHandlerModifiable invHandler, RandomSource random) {
        this.completeRecipeProcessing(recipe, invHandler, random, false);
    }

    protected void completeRecipeProcessing(RecipeHolder<CentrifugeRecipe> recipe, IItemHandlerModifiable invHandler, RandomSource random, boolean stripWax) {
        ((CentrifugeRecipe)recipe.value()).getRecipeOutputs().forEach((itemStack, recipeValues) -> {
            if (!(stripWax && itemStack.is(ModTags.Common.WAXES) || !(random.nextFloat() <= recipeValues.chance()))) {
                int count = Mth.nextInt((RandomSource)random, (int)Mth.floor((float)recipeValues.min()), (int)Mth.floor((float)recipeValues.max()));
                ItemStack output = itemStack.copy();
                output.setCount(count);
                ((InventoryHandlerHelper.BlockEntityItemStackHandler)invHandler).addOutput(output);
            }
        });
        invHandler.getStackInSlot(1).shrink(1);
        FluidStack fluidOutput = ((CentrifugeRecipe)recipe.value()).getFluidOutputs();
        if (!fluidOutput.isEmpty()) {
            this.fluidHandler.fill(fluidOutput.copy(), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void completeGeneProcessing(IItemHandlerModifiable invHandler, RandomSource random) {
        ItemStack geneBottle = invHandler.getStackInSlot(1);
        List<GeneGroup> entityData = GeneBottle.getGenes(geneBottle);
        if (entityData.isEmpty()) {
            return;
        }
        double chance = (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.geneExtractChance.get();
        for (GeneGroup geneGroup : entityData) {
            if (!(random.nextDouble() <= chance)) continue;
            ((InventoryHandlerHelper.BlockEntityItemStackHandler)invHandler).addOutput(Gene.getStack(geneGroup, 1));
        }
        invHandler.getStackInSlot(1).shrink(1);
    }

    private void completeTreatProcessing(IItemHandlerModifiable invHandler) {
        ItemStack honeyTreat = invHandler.getStackInSlot(1);
        List<GeneGroup> genes = HoneyTreat.getGenes(honeyTreat);
        if (!genes.isEmpty()) {
            for (GeneGroup geneGroup : genes) {
                ItemStack insertedGene = Gene.getStack(geneGroup, 1);
                ((InventoryHandlerHelper.BlockEntityItemStackHandler)invHandler).addOutput(insertedGene);
            }
        }
        invHandler.getStackInSlot(1).shrink(1);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        this.recipeProgress = tag.getInt("RecipeProgress");
        Fluid fluid = this.fluidHandler.getFluidInTank(0).getFluid();
        this.fluidId = BuiltInRegistries.FLUID.getId((Object)fluid);
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.putInt("RecipeProgress", this.recipeProgress);
    }

    @Nonnull
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.CENTRIFUGE.get()).getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CentrifugeContainer(pContainerId, pPlayerInventory, this);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }
}

