/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.container.CatcherContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivelib.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CatcherBlockEntity
extends CapabilityBlockEntity
implements MenuProvider,
UpgradeableBlockEntity {
    protected int tickCounter = 0;
    public IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 11, (BlockEntity)this){

        public boolean isContainerItem(Item item) {
            return item instanceof BeeCage;
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_CHILD.get(), (Item)LibItems.UPGRADE_ADULT.get(), (Item)LibItems.UPGRADE_RANGE.get(), (Item)LibItems.UPGRADE_ENTITY_FILTER.get()));

    public CatcherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.CATCHER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CatcherBlockEntity blockEntity) {
        ItemStack invItem;
        if (++blockEntity.tickCounter % 69 == 0 && !blockEntity.inventoryHandler.getStackInSlot(0).isEmpty() && (invItem = blockEntity.inventoryHandler.getStackInSlot(0)).getItem() instanceof BeeCage && !BeeCage.isFilled(invItem)) {
            List bees = level.getEntitiesOfClass(Bee.class, blockEntity.getBoundingBox());
            int babeeUpgrades = blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_CHILD.get());
            int notBabeeUpgrades = blockEntity.getUpgradeCount((Item)LibItems.UPGRADE_ADULT.get());
            List filterUpgrades = blockEntity.getInstalledUpgrades((Item)LibItems.UPGRADE_ENTITY_FILTER.get());
            for (Bee bee : bees) {
                if (babeeUpgrades > 0 && !bee.isBaby() || notBabeeUpgrades > 0 && bee.isBaby()) continue;
                boolean isAllowed = filterUpgrades.isEmpty();
                if (!filterUpgrades.isEmpty()) {
                    for (ItemStack filter : filterUpgrades) {
                        List entities = (List)filter.getOrDefault(ModDataComponents.ENTITY_TYPE_LIST, new ArrayList());
                        for (ResourceLocation allowedBee : entities) {
                            String type = BeeIngredientFactory.getIngredientKey(bee);
                            if (!allowedBee.toString().equals(type)) continue;
                            isAllowed = true;
                        }
                    }
                }
                if (!isAllowed || invItem.getCount() <= 0) continue;
                bee.setSavedFlowerPos(null);
                bee.hivePos = null;
                ItemStack cageStack = new ItemStack((ItemLike)invItem.getItem());
                BeeCage.captureEntity(bee, cageStack);
                if (((InventoryHandlerHelper.BlockEntityItemStackHandler)blockEntity.inventoryHandler).addOutput(cageStack).getCount() != 0) continue;
                bee.discard();
                invItem.shrink(1);
            }
        }
    }

    private AABB getBoundingBox() {
        int rangeUpgrades = this.getUpgradeCount((Item)LibItems.UPGRADE_RANGE.get());
        return new AABB(this.worldPosition).inflate((double)rangeUpgrades, 2.0 + (double)rangeUpgrades, (double)rangeUpgrades);
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Nonnull
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.CATCHER.get()).getDescriptionId());
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new CatcherContainer(windowId, playerInventory, this);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }
}

