/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.farmersdelight.ponder;

import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import com.simibubi.create.infrastructure.ponder.scenes.highLogistics.PonderHilo;
import java.util.List;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.DisplayWorldSectionInstruction;
import net.createmod.ponder.foundation.instruction.FadeOutOfSceneInstruction;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.block.entity.StoveBlockEntity;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;

public class FDPonderScenes {
    public static void cookingPot(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cooking_pot", "Automating with Create: Cooking Pot");
        scene.configureBasePlate(0, 0, 8);
        scene.scaleSceneView(0.77f);
        scene.showBasePlate();
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(1, 1, 2, 1, 2, 2).add(util.select().fromTo(0, 2, 3, 1, 2, 3)), Direction.DOWN);
        scene.overlay().showText(60).text("Use Packager to automate ingredient insertion").pointAt(util.vector().centerOf(1, 2, 3)).placeNearTarget();
        scene.idle(40);
        scene.world().showSection(util.select().fromTo(4, 1, 4, 6, 3, 6), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(3, 2, 5), Direction.DOWN);
        scene.idle(5);
        Selection belt1 = util.select().fromTo(3, 1, 5, 2, 1, 5);
        scene.world().showSection(belt1, Direction.EAST);
        scene.idle(5);
        Selection belt2 = util.select().fromTo(1, 1, 3, 1, 1, 5);
        scene.world().showSection(belt2, Direction.NORTH);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 2, 4).add(util.select().position(2, 2, 5)), Direction.DOWN);
        scene.idle(5);
        scene.world().setKineticSpeed(belt1, 64.0f);
        scene.idle(5);
        scene.world().setKineticSpeed(belt2, -64.0f);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 1, 6, 3, 2).add(util.select().position(3, 3, 5)), Direction.DOWN);
        scene.overlay().showText(80).text("Factory gauges are very useful in the packaging process").pointAt(util.vector().centerOf(1, 2, 3)).attachKeyFrame().placeNearTarget();
        BlockPos outFG = util.grid().at(4, 2, 1);
        builder.world().modifyBlockEntity(outFG, FactoryPanelBlockEntity.class, be -> {
            FactoryPanelBehaviour panel = (FactoryPanelBehaviour)be.panels.get(FactoryPanelBlock.PanelSlot.TOP_RIGHT);
            panel.addConnection(new FactoryPanelPosition(util.grid().at(5, 2, 1), FactoryPanelBlock.PanelSlot.BOTTOM_RIGHT));
            panel.addConnection(new FactoryPanelPosition(util.grid().at(5, 3, 1), FactoryPanelBlock.PanelSlot.BOTTOM_RIGHT));
            panel.addConnection(new FactoryPanelPosition(util.grid().at(6, 2, 1), FactoryPanelBlock.PanelSlot.TOP_RIGHT));
            panel.addConnection(new FactoryPanelPosition(util.grid().at(6, 3, 1), FactoryPanelBlock.PanelSlot.TOP_RIGHT));
        });
        scene.idle(40);
        builder.world().modifyBlockEntity(outFG, FactoryPanelBlockEntity.class, be -> {
            FactoryPanelBehaviour panel = (FactoryPanelBehaviour)be.panels.get(FactoryPanelBlock.PanelSlot.TOP_RIGHT);
            panel.count = 4;
        });
        scene.idle(10);
        PonderHilo.linkEffect((CreateSceneBuilder)scene, (BlockPos)util.grid().at(3, 3, 5));
        ItemStack pack = PackageItem.containing(List.of(Items.CARROT.getDefaultInstance(), ((Item)ModItems.CABBAGE_LEAF.get()).getDefaultInstance(), ((Item)ModItems.ONION.get()).getDefaultInstance(), ((Item)ModItems.CHICKEN_CUTS.get()).getDefaultInstance()));
        BlockPos outPackager = util.grid().at(3, 2, 5);
        PonderHilo.packagerCreate((CreateSceneBuilder)scene, (BlockPos)outPackager, (ItemStack)pack);
        scene.idle(5);
        scene.world().createItemOnBelt(util.grid().at(3, 1, 5), Direction.EAST, pack);
        PonderHilo.packagerClear((CreateSceneBuilder)scene, (BlockPos)outPackager);
        scene.idle(20);
        scene.world().removeItemsFromBelt(util.grid().at(1, 1, 4));
        PonderHilo.packagerUnpack((CreateSceneBuilder)scene, (BlockPos)util.grid().at(1, 2, 3), (ItemStack)pack);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 1, 2).add(util.select().fromTo(3, 1, 4, 3, 2, 4)), Direction.DOWN);
        scene.world().setKineticSpeed(util.select().position(2, 1, 2), 128.0f);
        scene.world().modifyBlockEntity(util.grid().at(3, 1, 4), DepotBlockEntity.class, depot -> depot.setHeldItem(Items.BOWL.getDefaultInstance()));
        scene.overlay().showText(60).text("Use Mechanical Arm to insert food container").pointAt(util.vector().centerOf(2, 1, 2)).attachKeyFrame().placeNearTarget();
        BlockPos armPos = util.grid().at(2, 1, 2);
        Selection inputDepot = util.select().position(3, 1, 4);
        Selection cookingPot = util.select().position(1, 2, 2);
        scene.overlay().showOutline(PonderPalette.INPUT, (Object)inputDepot, inputDepot, 40);
        scene.overlay().showOutline(PonderPalette.OUTPUT, (Object)cookingPot, cookingPot, 40);
        scene.idle(40);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, 0);
        scene.idle(20);
        scene.world().modifyBlockEntity(util.grid().at(3, 1, 4), DepotBlockEntity.class, depot -> depot.setHeldItem(ItemStack.EMPTY));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, Items.BOWL.getDefaultInstance(), -1);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, Items.BOWL.getDefaultInstance(), 0);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, -1);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(0, 1, 0, 1, 1, 0), Direction.DOWN);
        scene.world().setKineticSpeed(util.select().position(0, 1, 0), 128.0f);
        scene.overlay().showText(60).text("Mechanical Arm can take out cooked food").pointAt(util.vector().centerOf(2, 1, 1)).attachKeyFrame().placeNearTarget();
        BlockPos armPos2 = util.grid().at(0, 1, 0);
        Selection outputDepot = util.select().position(1, 1, 0);
        scene.overlay().showOutline(PonderPalette.INPUT, (Object)cookingPot, cookingPot, 40);
        scene.overlay().showOutline(PonderPalette.OUTPUT, (Object)outputDepot, outputDepot, 40);
        scene.idle(40);
        scene.world().instructArm(armPos2, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, 0);
        scene.idle(20);
        scene.world().instructArm(armPos2, ArmBlockEntity.Phase.SEARCH_OUTPUTS, ((Item)ModItems.CHICKEN_SOUP.get()).getDefaultInstance(), -1);
        scene.idle(20);
        scene.world().instructArm(armPos2, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, ((Item)ModItems.CHICKEN_SOUP.get()).getDefaultInstance(), 0);
        scene.idle(20);
        scene.world().modifyBlockEntity(util.grid().at(1, 1, 0), DepotBlockEntity.class, depot -> depot.setHeldItem(((Item)ModItems.CHICKEN_SOUP.get()).getDefaultInstance()));
        scene.world().instructArm(armPos2, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, -1);
        scene.idle(10);
        scene.world().showSection(util.select().position(0, 2, 2), Direction.EAST);
        scene.overlay().showText(60).text("Funnel also can take out cooked food").pointAt(util.vector().centerOf(0, 2, 2)).attachKeyFrame().placeNearTarget();
        scene.idle(60);
    }

    public static void heatSource(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("heat_source", "Heat sources for Cooking");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        ElementLink boiler = scene.world().showIndependentSection(util.select().fromTo(3, 4, 1, 3, 5, 1).add(util.select().position(2, 5, 1)).add(util.select().position(0, 5, 1)), Direction.DOWN);
        ElementLink blazeBurner1 = scene.world().showIndependentSection(util.select().position(3, 3, 1), Direction.DOWN);
        scene.world().moveSection(blazeBurner1, new Vec3(0.0, -2.0, 0.0), 0);
        scene.world().moveSection(boiler, new Vec3(0.0, -2.0, 0.0), 0);
        scene.overlay().showText(60).text("This is a Blaze Burner, a common boiler heater").pointAt(util.vector().centerOf(3, 1, 1)).placeNearTarget();
        scene.idle(70);
        scene.world().hideIndependentSection(boiler, Direction.UP);
        ElementLink blazeBurner2 = scene.world().showIndependentSection(util.select().position(1, 3, 1), Direction.DOWN);
        scene.world().moveSection(blazeBurner2, new Vec3(0.0, -2.0, 0.0), 0);
        scene.overlay().showText(60).text("Boiler heaters are valid heat sources for cooking utensils").pointAt(util.vector().centerOf(1, 1, 1)).attachKeyFrame();
        scene.idle(10);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(3, 2, 1), Direction.UP), Pointing.DOWN, 20).rightClick().withItem(((Block)ModBlocks.COOKING_POT.get()).asItem().getDefaultInstance());
        scene.idle(10);
        scene.addInstruction((PonderInstruction)new FadeOutOfSceneInstruction(0, Direction.DOWN, blazeBurner1));
        scene.addInstruction((PonderInstruction)new DisplayWorldSectionInstruction(0, Direction.DOWN, util.select().fromTo(3, 1, 1, 3, 2, 1), () -> ((PonderScene)scene.getScene()).getBaseWorldSection()));
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(1, 2, 1), Direction.UP), Pointing.DOWN, 20).whileCTRL().rightClick().withItem(((Block)ModBlocks.SKILLET.get()).asItem().getDefaultInstance());
        scene.idle(10);
        scene.addInstruction((PonderInstruction)new FadeOutOfSceneInstruction(0, Direction.DOWN, blazeBurner2));
        scene.addInstruction((PonderInstruction)new DisplayWorldSectionInstruction(0, Direction.DOWN, util.select().fromTo(1, 1, 1, 1, 2, 1), () -> ((PonderScene)scene.getScene()).getBaseWorldSection()));
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 1, 2, 3), Direction.DOWN);
        scene.world().hideSection(util.select().fromTo(3, 1, 1, 3, 2, 1), Direction.UP);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(3, 1, 2, 3, 2, 2), Direction.DOWN);
        scene.overlay().showText(120).text("Boiler heaters accelerate some cooking utensils according to its heat-level").attachKeyFrame().pointAt(util.vector().centerOf(1, 1, 3));
        scene.idle(10);
        scene.world().modifyBlockEntity(util.grid().at(1, 2, 1), SkilletBlockEntity.class, be -> be.getInventory().insertItem(0, Items.PORKCHOP.getDefaultInstance(), false));
        scene.world().modifyBlockEntity(util.grid().at(1, 2, 3), SkilletBlockEntity.class, be -> be.getInventory().insertItem(0, Items.PORKCHOP.getDefaultInstance(), false));
        scene.world().modifyBlockEntity(util.grid().at(3, 2, 2), SkilletBlockEntity.class, be -> be.getInventory().insertItem(0, Items.PORKCHOP.getDefaultInstance(), false));
        scene.idle(20);
        scene.world().createItemEntity(util.vector().of(1.5, 2.3, 3.5), new Vec3(0.0, 0.25, (double)-0.08f), Items.COOKED_PORKCHOP.getDefaultInstance());
        scene.world().modifyBlockEntity(util.grid().at(1, 2, 3), SkilletBlockEntity.class, SkilletBlockEntity::removeItem);
        scene.idle(20);
        scene.world().createItemEntity(util.vector().of(3.5, 2.3, 2.5), new Vec3(0.0, 0.25, (double)-0.08f), Items.COOKED_PORKCHOP.getDefaultInstance());
        scene.world().modifyBlockEntity(util.grid().at(3, 2, 2), SkilletBlockEntity.class, SkilletBlockEntity::removeItem);
        scene.idle(40);
        scene.world().createItemEntity(util.vector().of(1.5, 2.3, 1.5), new Vec3(0.0, 0.25, (double)-0.08f), Items.COOKED_PORKCHOP.getDefaultInstance());
        scene.world().modifyBlockEntity(util.grid().at(1, 2, 1), SkilletBlockEntity.class, SkilletBlockEntity::removeItem);
    }

    public static void stoveAndSkillet(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("skillet_and_stove", "Automating with Create: Skillet and Stove");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(10);
        BlockPos armPos = util.grid().at(3, 1, 1);
        Selection arm = util.select().position(3, 1, 1);
        Selection depot = util.select().position(2, 1, 1);
        BlockPos depotPos = util.grid().at(2, 1, 1);
        Selection stove = util.select().position(3, 1, 3);
        BlockPos stovePos = util.grid().at(3, 1, 3);
        Selection skillet = util.select().position(1, 2, 3);
        BlockPos skilletPos = util.grid().at(1, 2, 3);
        scene.world().showSection(stove.add(util.select().fromTo(1, 1, 3, 1, 2, 3).add(arm)), Direction.DOWN);
        scene.overlay().showText(60).text("Mechanical Arm can put raw ingredient onto Stove and Skillet").pointAt(util.vector().centerOf(3, 1, 1)).placeNearTarget();
        scene.idle(10);
        scene.world().showSection(depot, Direction.DOWN);
        scene.world().setKineticSpeed(arm, 64.0f);
        scene.overlay().showOutline(PonderPalette.INPUT, (Object)depot, depot, 40);
        scene.overlay().showOutline(PonderPalette.OUTPUT, (Object)stove, stove.add(skillet), 40);
        scene.idle(40);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> be.setHeldItem(Items.BEEF.getDefaultInstance()));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, 0);
        scene.idle(20);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> be.setHeldItem(ItemStack.EMPTY));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, Items.BEEF.getDefaultInstance(), -1);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, Items.BEEF.getDefaultInstance(), 0);
        scene.idle(20);
        scene.world().modifyBlockEntity(skilletPos, SkilletBlockEntity.class, be -> be.getInventory().insertItem(0, Items.BEEF.getDefaultInstance(), false));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, -1);
        scene.idle(10);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> be.setHeldItem(Items.BEEF.getDefaultInstance()));
        scene.idle(10);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, 0);
        scene.idle(20);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> be.setHeldItem(ItemStack.EMPTY));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, Items.BEEF.getDefaultInstance(), -1);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, Items.BEEF.getDefaultInstance(), 1);
        scene.idle(20);
        scene.world().modifyBlockEntity(stovePos, StoveBlockEntity.class, be -> be.getInventory().insertItem(0, Items.BEEF.getDefaultInstance(), false));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, -1);
        scene.idle(10);
    }

    public static void cuttingBoard(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("cutting_board", "Automating with Create: Cutting");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.85f);
        Selection belt = util.select().fromTo(5, 0, 0, 5, 0, 6);
        Selection belt2 = util.select().fromTo(1, 0, 0, 1, 0, 6);
        scene.world().showSection(util.select().layer(0).substract(belt).substract(belt2), Direction.DOWN);
        ElementLink tempGround = scene.world().showIndependentSection(util.select().fromTo(5, 3, 0, 5, 3, 6), Direction.DOWN);
        ElementLink tempGround2 = scene.world().showIndependentSection(util.select().fromTo(1, 3, 0, 1, 3, 6), Direction.DOWN);
        scene.world().moveSection(tempGround, new Vec3(0.0, -3.0, 0.0), 0);
        scene.world().moveSection(tempGround2, new Vec3(0.0, -3.0, 0.0), 0);
        ElementLink tempBoard = scene.world().showIndependentSection(util.select().position(3, 3, 3), Direction.DOWN);
        scene.world().moveSection(tempBoard, new Vec3(0.0, -2.0, 0.0), 0);
        scene.idle(10);
        scene.overlay().showText(40).text("This is a Cutting Board. Previously, it could semi-automated with Deployer").pointAt(util.vector().centerOf(3, 1, 3)).placeNearTarget();
        scene.idle(40);
        scene.addInstruction((PonderInstruction)new FadeOutOfSceneInstruction(0, Direction.UP, tempBoard));
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 3, 1, 5).substract(belt), Direction.DOWN);
        scene.overlay().showText(40).text("Now, Mechanical Arm can put raw ingredient on Cutting Board").pointAt(util.vector().centerOf(3, 1, 3)).attachKeyFrame().placeNearTarget();
        BlockPos armPos = util.grid().at(3, 1, 5);
        Selection arm = util.select().position(3, 1, 5);
        Selection depot = util.select().position(3, 1, 1);
        BlockPos depotPos = util.grid().at(3, 1, 1);
        Selection cuttingBoard = util.select().position(3, 1, 3);
        BlockPos cuttingBoardPos = util.grid().at(3, 1, 3);
        scene.world().setKineticSpeed(arm, 64.0f);
        scene.overlay().showOutline(PonderPalette.INPUT, (Object)depot, depot, 40);
        scene.overlay().showOutline(PonderPalette.OUTPUT, (Object)cuttingBoard, cuttingBoard, 40);
        scene.idle(40);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> be.setHeldItem(Items.CHICKEN.getDefaultInstance()));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, 0);
        scene.idle(20);
        scene.world().modifyBlockEntity(depotPos, DepotBlockEntity.class, be -> be.setHeldItem(ItemStack.EMPTY));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, Items.CHICKEN.getDefaultInstance(), -1);
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_OUTPUT, Items.CHICKEN.getDefaultInstance(), 0);
        scene.idle(20);
        scene.world().modifyBlockEntity(cuttingBoardPos, CuttingBoardBlockEntity.class, be -> be.getInventory().insertItem(0, Items.CHICKEN.getDefaultInstance(), false));
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, -1);
        scene.idle(10);
        Selection deployer = util.select().position(5, 2, 3);
        BlockPos deployerPos = util.grid().at(5, 2, 3);
        scene.world().hideIndependentSection(tempGround, Direction.DOWN);
        scene.world().showSection(belt.add(deployer), Direction.DOWN);
        ItemStack tool = ((Item)ModItems.IRON_KNIFE.get()).getDefaultInstance();
        if (!DatagenModLoader.isRunningDataGen()) {
            scene.world().modifyBlockEntityNBT(deployer, DeployerBlockEntity.class, nbt -> {
                nbt.put("HeldItem", tool.saveOptional(scene.world().getHolderLookupProvider()));
                nbt.putString("Mode", "USE");
            });
        }
        scene.overlay().showText(60).text("Deployer with a knife in Use Mode can cut raw ingredient").pointAt(util.vector().centerOf(5, 2, 3)).attachKeyFrame().placeNearTarget();
        scene.idle(10);
        scene.world().setKineticSpeed(belt.add(deployer), 32.0f);
        ElementLink chicken = scene.world().createItemOnBelt(util.grid().at(5, 0, 1), Direction.DOWN, ((Item)ModItems.CABBAGE.get()).getDefaultInstance());
        scene.idle(30);
        scene.world().stallBeltItem(chicken, true);
        scene.world().moveDeployer(deployerPos, 1.0f, 30);
        scene.idle(30);
        scene.world().changeBeltItemTo(chicken, new ItemStack((ItemLike)ModItems.CABBAGE_LEAF.get(), 2));
        scene.world().moveDeployer(deployerPos, -1.0f, 30);
        scene.idle(10);
        scene.world().stallBeltItem(chicken, false);
        scene.idle(10);
        Selection saw = util.select().position(1, 0, 3);
        scene.world().hideIndependentSection(tempGround2, Direction.DOWN);
        scene.world().showSection(belt2, Direction.DOWN);
        scene.overlay().showText(60).text("Mechanical Saw also can cut raw ingredient").pointAt(util.vector().centerOf(1, 0, 3)).attachKeyFrame().placeNearTarget();
        scene.idle(10);
        scene.world().setKineticSpeed(belt2.substract(saw), 32.0f);
        scene.world().setKineticSpeed(saw, -128.0f);
        scene.world().createItemOnBelt(util.grid().at(1, 0, 1), Direction.DOWN, Items.CHICKEN.getDefaultInstance());
        scene.idle(60);
    }
}

