/*
 * Decompiled with CFR 0.152.
 */
package net.countered.counteredsaccuratehitboxes.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.counteredsaccuratehitboxes.client.ModRenderLayers;
import net.countered.counteredsaccuratehitboxes.client.ModStuckObjectsFeatureRenderer;
import net.countered.counteredsaccuratehitboxes.mixin.accessors.AnimalModelAccessor;
import net.countered.counteredsaccuratehitboxes.mixin.accessors.MixinCuboidAccessor;
import net.countered.counteredsaccuratehitboxes.mixin.accessors.ModelPartAccessor;
import net.countered.counteredsaccuratehitboxes.util.HitboxAttachment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class HitboxFeatureRenderer<T extends class_1309, M extends class_583<T>>
extends ModStuckObjectsFeatureRenderer<T, M> {
    private static final List<class_1299> babyAllowed = new ArrayList<class_1299>();

    public HitboxFeatureRenderer(class_5617.class_5618 context, class_922<T, M> entityRenderer) {
        super(entityRenderer);
    }

    @Override
    protected void renderAtPart(List<class_630> modelPartList, class_4587 matrices, class_4597 vertexConsumers, int light, T entity, float tickDelta) {
        ArrayList<List<Vector3f>> vertexCol = new ArrayList<List<Vector3f>>();
        if (entity.method_6109() && !babyAllowed.contains(entity.method_5864())) {
            return;
        }
        class_583 model = this.method_17165();
        for (class_630 modelPart : modelPartList) {
            HashSet<class_630> excludedParts = new HashSet<class_630>();
            vertexCol.addAll(this.createHitboxes(matrices, modelPart, entity, vertexConsumers, light, excludedParts));
        }
        entity.setAttached(HitboxAttachment.HITBOXES, vertexCol);
    }

    private List<List<Vector3f>> createHitboxes(class_4587 matrices, class_630 modelPart, T entity, class_4597 vertexConsumers, int light, Set<class_630> excludedParts) {
        if (modelPart.method_41919("hat_rim")) {
            excludedParts.add(modelPart.method_32086("hat_rim"));
        }
        if (excludedParts.contains(modelPart)) {
            return Collections.emptyList();
        }
        ArrayList<List<Vector3f>> vertexList = new ArrayList<List<Vector3f>>();
        matrices.method_22903();
        if (entity.method_6109()) {
            this.scaleBabyMatices(entity, modelPart, matrices);
        }
        if (entity.method_5864().equals(class_1299.field_6140)) {
            matrices.method_22905(0.6f, 0.6f, 0.6f);
            matrices.method_46416(0.0f, 1.0f, 0.0f);
        }
        if (modelPart.field_3665) {
            List<class_630.class_628> cuboids = ((ModelPartAccessor)modelPart).getCuboids();
            modelPart.method_22703(matrices);
            for (class_630.class_628 cuboid : cuboids) {
                List<Vector3f> vertices = this.getCuboidHitbox(cuboid, modelPart, matrices);
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                class_243 cameraPos = camera.method_19326();
                for (Vector3f vertex : vertices) {
                    vertex.add((Vector3fc)cameraPos.method_46409());
                }
                vertexList.add(vertices);
            }
            for (class_630 modelChildren : ((ModelPartAccessor)modelPart).getChildren().values()) {
                vertexList.addAll(this.createHitboxes(matrices, modelChildren, entity, vertexConsumers, light, excludedParts));
            }
        }
        matrices.method_22909();
        return vertexList;
    }

    private void scaleBabyMatices(T entity, class_630 modelPart, class_4587 matrices) {
        class_583 class_5832 = this.method_17165();
        if (class_5832 instanceof class_572) {
            class_572 model = (class_572)class_5832;
            if (modelPart.equals(model.field_3398)) {
                matrices.method_22905(0.75f, 0.75f, 0.75f);
                matrices.method_46416(0.0f, 1.0f, 0.0f);
                return;
            }
        } else {
            class_5832 = this.method_17165();
            if (class_5832 instanceof class_4592) {
                class_4592 model = (class_4592)class_5832;
                ArrayList headPartList = new ArrayList();
                ((AnimalModelAccessor)model).getHeadParts().forEach(part -> headPartList.add((class_630)part));
                if (!headPartList.isEmpty() && ((class_630)headPartList.get(0)).equals(modelPart)) {
                    matrices.method_46416(0.0f, ((AnimalModelAccessor)model).getChildHeadYOffset() / 16.0f, ((AnimalModelAccessor)model).getChildHeadZOffset() / 16.0f);
                    return;
                }
            }
        }
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        matrices.method_22904(0.0, 1.5, 0.0);
    }

    public List<Vector3f> getCuboidHitbox(class_630.class_628 cuboid, class_630 modelPart, class_4587 matrices) {
        float x1 = cuboid.field_3645 / 16.0f;
        float y1 = cuboid.field_3644 / 16.0f;
        float z1 = cuboid.field_3643 / 16.0f;
        float x2 = cuboid.field_3648 / 16.0f;
        float y2 = cuboid.field_3647 / 16.0f;
        float z2 = cuboid.field_3646 / 16.0f;
        Vector3f[] cubeVerts = new Vector3f[]{new Vector3f(x1, y1, z1), new Vector3f(x2, y1, z1), new Vector3f(x1, y2, z1), new Vector3f(x2, y2, z1), new Vector3f(x1, y1, z2), new Vector3f(x2, y1, z2), new Vector3f(x1, y2, z2), new Vector3f(x2, y2, z2)};
        Matrix4f matrix = matrices.method_23760().method_23761();
        for (int i = 0; i < cubeVerts.length; ++i) {
            cubeVerts[i] = matrix.transformPosition(cubeVerts[i]);
        }
        return Arrays.asList(cubeVerts);
    }

    private void makePartGlow(class_1297 entity, class_4597 vertexConsumers, class_4587 matrices, int overlay, int light, class_630.class_628 cuboid, class_630 modelPart) {
        float pulse = (class_3532.method_15374((float)((float)entity.field_6012 * 0.25f)) + 1.0f) / 2.0f;
        int alpha = (int)(pulse * 80.0f) + 100;
        int red = 250;
        int green = 30;
        int blue = 30;
        int color = alpha << 24 | red << 16 | green << 8 | blue;
        class_4588 vertexConsumer = vertexConsumers.getBuffer(ModRenderLayers.WEAK_SPOT_LAYER);
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Vector3f vector3f = new Vector3f();
        for (class_630.class_593 quad : ((MixinCuboidAccessor)cuboid).getSides()) {
            Vector3f vector3f2 = entry.method_56821(quad.field_21618, vector3f);
            float f = vector3f2.x();
            float g = vector3f2.y();
            float h = vector3f2.z();
            for (class_630.class_618 vertex : quad.field_3502) {
                Vector3f transformedPos = new Vector3f(vertex.field_3605.x() / 16.0f, vertex.field_3605.y() / 16.0f, vertex.field_3605.z() / 16.0f);
                transformedPos = matrix4f.transformPosition(transformedPos);
                vertexConsumer.method_23919(transformedPos.x(), transformedPos.y(), transformedPos.z(), color, vertex.field_3604, vertex.field_3603, overlay, light, f, g, h);
            }
        }
    }

    static {
        babyAllowed.add(class_1299.field_6051);
        babyAllowed.add(class_1299.field_6054);
        babyAllowed.add(class_1299.field_22281);
        babyAllowed.add(class_1299.field_6050);
        babyAllowed.add(class_1299.field_6085);
        babyAllowed.add(class_1299.field_6093);
        babyAllowed.add(class_1299.field_6115);
    }
}

