/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import com.mojang.datafixers.DataFixUtils;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.cominixo.betterf3.ducks.ChunkBuilderAccess;
import me.cominixo.betterf3.ducks.ClientChunkManagerAccess;
import me.cominixo.betterf3.ducks.ClientChunkMapAccess;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;

public class ChunksModule
extends BaseModule {
    public TextColor totalColor;
    public final TextColor defaultTotalColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GOLD);
    public final TextColor defaultEnabledColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GREEN);
    public final TextColor defaultDisabledColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED);
    public TextColor enabledColor;
    public TextColor disabledColor;

    public ChunksModule() {
        this.defaultNameColor = TextColor.fromRgb((int)43775);
        this.defaultValueColor = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.YELLOW);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.totalColor = this.defaultTotalColor;
        this.enabledColor = this.defaultEnabledColor;
        this.disabledColor = this.defaultDisabledColor;
        this.lines.add(new DebugLine("chunk_sections", "format.betterf3.total", true));
        this.lines.add(new DebugLine("chunk_culling"));
        this.lines.add(new DebugLine("pending_chunks"));
        this.lines.add(new DebugLine("pending_uploads"));
        this.lines.add(new DebugLine("available_buffers"));
        this.lines.add(new DebugLine("client_chunk_cache"));
        this.lines.add(new DebugLine("loaded_chunks"));
        this.lines.add(new DebugLine("loaded_chunks_server"));
        this.lines.add(new DebugLine("forceloaded_chunks"));
        this.lines.add(new DebugLine("spawn_chunks"));
        this.lines.add(new DebugLine("chunk_file"));
        ((DebugLine)this.lines.get((int)0)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)2)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)3)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)4)).inReducedDebug = true;
        ((DebugLine)this.lines.get((int)5)).inReducedDebug = true;
    }

    @Override
    public void update(Minecraft client) {
        LongSets.EmptySet emptySet;
        Level world;
        int totalChunks = client.levelRenderer.viewArea == null ? 0 : client.levelRenderer.viewArea.sections.length;
        int renderedChunks = client.levelRenderer.countRenderedSections();
        SectionRenderDispatcher chunkBuilder = client.levelRenderer.getSectionRenderDispatcher();
        ChunkBuilderAccess chunkBuilderDuck = (ChunkBuilderAccess)chunkBuilder;
        if (client.level != null) {
            ClientChunkCache clientChunkManager = client.level.getChunkSource();
            ClientChunkManagerAccess clientChunkManagerMixin = (ClientChunkManagerAccess)clientChunkManager;
            ClientChunkMapAccess clientChunkMapMixin = (ClientChunkMapAccess)clientChunkManagerMixin.getChunks();
            ((DebugLine)this.lines.get(5)).value(clientChunkMapMixin.getChunks().length());
            ((DebugLine)this.lines.get(6)).value(clientChunkManager.getLoadedChunksCount());
        }
        if ((world = (Level)DataFixUtils.orElse(Optional.ofNullable(client.getSingleplayerServer()).flatMap(integratedServer -> Optional.ofNullable(integratedServer.getLevel(client.level.dimension()))), (Object)client.level)) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            emptySet = serverLevel.getForcedChunks();
        } else {
            emptySet = LongSets.EMPTY_SET;
        }
        LongSets.EmptySet forceLoadedChunks = emptySet;
        IntegratedServer integratedServer2 = client.getSingleplayerServer();
        ServerLevel serverWorld = integratedServer2 != null ? integratedServer2.getLevel(client.level.dimension()) : null;
        NaturalSpawner.SpawnState info = null;
        if (serverWorld != null) {
            info = serverWorld.getChunkSource().getLastSpawnState();
        }
        String chunkCulling = client.smartCull ? I18n.get((String)"text.betterf3.line.enabled", (Object[])new Object[0]) : I18n.get((String)"text.betterf3.line.disabled", (Object[])new Object[0]);
        List<Component> chunkValues = Arrays.asList(Utils.styledText(I18n.get((String)"text.betterf3.line.rendered", (Object[])new Object[0]), this.valueColor), Utils.styledText(I18n.get((String)"text.betterf3.line.total", (Object[])new Object[0]), this.totalColor), Utils.styledText(Integer.toString(renderedChunks), this.valueColor), Utils.styledText(Integer.toString(totalChunks), this.totalColor));
        ((DebugLine)this.lines.get(0)).value(chunkValues);
        ((DebugLine)this.lines.get(1)).value(Utils.styledText(chunkCulling, client.smartCull ? this.enabledColor : this.disabledColor));
        if (chunkBuilderDuck != null) {
            ((DebugLine)this.lines.get(2)).value(client.levelRenderer.getSectionRenderDispatcher().getToBatchCount());
            ((DebugLine)this.lines.get(3)).value(client.levelRenderer.getSectionRenderDispatcher().getToUpload());
            ((DebugLine)this.lines.get(4)).value(client.levelRenderer.getSectionRenderDispatcher().getFreeBufferCount());
        }
        if (serverWorld != null) {
            ((DebugLine)this.lines.get(7)).value(serverWorld.getChunkSource().getLoadedChunksCount());
        }
        ((DebugLine)this.lines.get(8)).value(forceLoadedChunks.size());
        if (info != null) {
            ((DebugLine)this.lines.get(9)).value(info.getSpawnableChunkCount());
        }
        BlockPos blockPos = Objects.requireNonNull(client.getCameraEntity()).blockPosition();
        ChunkPos chunkPos = new ChunkPos(blockPos);
        String regionFile = "r.%d.%d.mca (%d, %d)".formatted(chunkPos.getRegionX(), chunkPos.getRegionZ(), chunkPos.getRegionLocalX(), chunkPos.getRegionLocalZ());
        ((DebugLine)this.lines.get(10)).value(regionFile);
    }
}

