/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.ChunksModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.EmptyModule;
import me.cominixo.betterf3.modules.EntityModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.modules.HelpModule;
import me.cominixo.betterf3.modules.SoundModule;
import me.cominixo.betterf3.modules.SystemModule;
import me.cominixo.betterf3.utils.DebugLine;
import net.minecraft.network.chat.TextColor;

public final class ModConfigFile {
    private static FileType storedFileType;
    public static final Runnable saveRunnable;

    private ModConfigFile() {
    }

    public static void load(FileType filetype) {
        Config general;
        storedFileType = filetype;
        File file = new File(storedFileType == FileType.JSON ? "config/betterf3.json" : "config/betterf3.toml");
        if (!file.exists()) {
            return;
        }
        FileConfig config = FileConfig.builder((File)file).concurrent().autosave().build();
        config.load();
        Config allModulesConfig = (Config)config.getOrElse("modules", () -> null);
        if (allModulesConfig != null) {
            for (BaseModule module : BaseModule.allModules) {
                String moduleName = module.id;
                Config moduleConfig = (Config)allModulesConfig.getOrElse(moduleName, () -> null);
                if (moduleConfig == null) continue;
                Config lines = (Config)moduleConfig.getOrElse("lines", () -> null);
                if (lines != null) {
                    for (Config.Entry e : lines.entrySet()) {
                        DebugLine line = module.line(e.getKey());
                        if (line == null) continue;
                        line.enabled = (Boolean)e.getValue();
                    }
                }
                if (module.defaultNameColor != null) {
                    module.nameColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("name_color", (Object)module.defaultNameColor.getValue())));
                }
                if (module.defaultValueColor != null) {
                    module.valueColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("value_color", (Object)module.defaultValueColor.getValue())));
                }
                if (module instanceof CoordsModule) {
                    CoordsModule coordsModule = (CoordsModule)module;
                    if (coordsModule.defaultColorX != null) {
                        coordsModule.colorX = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_x", (Object)coordsModule.defaultColorX.getValue())));
                    }
                    if (coordsModule.defaultColorY != null) {
                        coordsModule.colorY = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_y", (Object)coordsModule.defaultColorY.getValue())));
                    }
                    if (coordsModule.defaultColorZ != null) {
                        coordsModule.colorZ = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_z", (Object)coordsModule.defaultColorZ.getValue())));
                    }
                }
                if (module instanceof SoundModule) {
                    SoundModule soundModule = (SoundModule)module;
                    if (soundModule.defaultMaximumColor != null) {
                        soundModule.maximumColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("maximum_color", (Object)soundModule.defaultMaximumColor.getValue())));
                    }
                }
                if (module instanceof EntityModule) {
                    EntityModule entityModule = (EntityModule)module;
                    if (entityModule.defaultTotalColor != null) {
                        entityModule.totalColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("total_entities_color", (Object)entityModule.defaultTotalColor.getValue())));
                    }
                }
                if (module instanceof HelpModule) {
                    HelpModule helpModule = (HelpModule)module;
                    if (helpModule.defaultEnabledColor != null) {
                        helpModule.enabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("enabled_color", (Object)helpModule.defaultEnabledColor.getValue())));
                    }
                    if (helpModule.defaultDisabledColor != null) {
                        helpModule.disabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("disabled_color", (Object)helpModule.defaultDisabledColor.getValue())));
                    }
                }
                if (module instanceof ChunksModule) {
                    ChunksModule chunkModule = (ChunksModule)module;
                    if (chunkModule.defaultEnabledColor != null) {
                        chunkModule.enabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("chunks_enabled_color", (Object)chunkModule.defaultEnabledColor.getValue())));
                    }
                    if (chunkModule.defaultDisabledColor != null) {
                        chunkModule.disabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("chunks_disabled_color", (Object)chunkModule.defaultDisabledColor.getValue())));
                    }
                    if (chunkModule.defaultTotalColor != null) {
                        chunkModule.totalColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("total_chunks_color", (Object)chunkModule.defaultTotalColor.getValue())));
                    }
                }
                if (module instanceof SystemModule) {
                    SystemModule systemModule = (SystemModule)module;
                    if (systemModule.memoryColorToggle == null) {
                        systemModule.memoryColorToggle = (Boolean)moduleConfig.getOrElse("memory_color_toggle", (Object)systemModule.defaultMemoryColorToggle);
                    }
                    if (systemModule.timeFormat == null) {
                        systemModule.timeFormat = (String)moduleConfig.getOrElse("time_format", (Object)systemModule.defaultTimeFormat);
                    }
                }
                module.enabled = (Boolean)moduleConfig.getOrElse("enabled", (Object)true);
            }
        } else {
            List modulesRightConfig;
            ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
            ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
            List modulesLeftConfig = (List)config.getOrElse("modules_left", () -> null);
            if (modulesLeftConfig != null) {
                for (Object moduleConfig : modulesLeftConfig) {
                    String moduleName = (String)moduleConfig.getOrElse("name", null);
                    if (moduleName == null) continue;
                    BaseModule baseModule = ModConfigFile.loadModule((Config)moduleConfig);
                    modulesLeft.add(baseModule);
                }
            }
            if ((modulesRightConfig = (List)config.getOrElse("modules_right", () -> null)) != null) {
                for (Config moduleConfig : modulesRightConfig) {
                    String moduleName = (String)moduleConfig.getOrElse("name", () -> null);
                    if (moduleName == null) continue;
                    BaseModule baseModule = ModConfigFile.loadModule(moduleConfig);
                    modulesRight.add(baseModule);
                }
            }
            if (!modulesLeft.isEmpty() || !modulesRight.isEmpty()) {
                BaseModule.modules = modulesLeft;
                BaseModule.modulesRight = modulesRight;
            }
        }
        if ((general = (Config)config.getOrElse("general", () -> null)) != null) {
            if (allModulesConfig != null) {
                BaseModule baseModule;
                ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
                ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
                for (Object s : (ArrayList)general.getOrElse("modules_left_order", new ArrayList())) {
                    baseModule = BaseModule.moduleById(s.toString());
                    if (baseModule == null) continue;
                    modulesLeft.add(baseModule);
                }
                if (!modulesLeft.isEmpty()) {
                    BaseModule.modules = modulesLeft;
                }
                for (Object s : (ArrayList)general.getOrElse("modules_right_order", new ArrayList())) {
                    baseModule = BaseModule.moduleById(s.toString());
                    if (baseModule == null) continue;
                    modulesRight.add(baseModule);
                }
                if (!modulesRight.isEmpty()) {
                    BaseModule.modulesRight = modulesRight;
                }
            }
            GeneralOptions.disableMod = (Boolean)general.getOrElse("disable_mod", (Object)false);
            GeneralOptions.autoF3 = (Boolean)general.getOrElse("auto_start", (Object)false);
            GeneralOptions.spaceEveryModule = (Boolean)general.getOrElse("space_modules", (Object)false);
            GeneralOptions.shadowText = (Boolean)general.getOrElse("shadow_text", (Object)true);
            GeneralOptions.enableAnimations = (Boolean)general.getOrElse("animations", (Object)true);
            GeneralOptions.animationSpeed = (Double)general.getOrElse("animationSpeed", (Object)1.0);
            GeneralOptions.fontScale = (Double)general.getOrElse("fontScale", (Object)1.0);
            GeneralOptions.backgroundColor = (Integer)general.getOrElse("background_color", (Object)1867534416);
            GeneralOptions.hideDebugCrosshair = (Boolean)general.getOrElse("hide_debug_crosshair", (Object)false);
            GeneralOptions.hideSidebar = (Boolean)general.getOrElse("hide_sidebar", (Object)true);
            GeneralOptions.hideBossbar = (Boolean)general.getOrElse("hide_bossbar", (Object)true);
            GeneralOptions.alwaysEnableProfiler = (Boolean)general.getOrElse("always_show_profiler", (Object)false);
            GeneralOptions.alwaysEnableTPS = (Boolean)general.getOrElse("always_show_tps", (Object)false);
            GeneralOptions.alwaysEnablePing = (Boolean)general.getOrElse("always_show_ping", (Object)false);
        }
        config.close();
    }

    private static BaseModule loadModule(Config moduleConfig) {
        BaseModule baseModule;
        String moduleName = (String)moduleConfig.getOrElse("name", null);
        try {
            baseModule = (BaseModule)BaseModule.moduleById(moduleName).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            baseModule = new EmptyModule(false);
        }
        Config lines = (Config)moduleConfig.getOrElse("lines", () -> null);
        if (lines != null) {
            for (Config.Entry e : lines.entrySet()) {
                DebugLine line = baseModule.line(e.getKey());
                if (line == null) continue;
                line.enabled = (Boolean)e.getValue();
            }
        }
        if (baseModule.defaultNameColor != null) {
            baseModule.nameColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("name_color", (Object)baseModule.defaultNameColor.getValue())));
        }
        if (baseModule.defaultValueColor != null) {
            baseModule.valueColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("value_color", (Object)baseModule.defaultValueColor.getValue())));
        }
        if (baseModule instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)baseModule;
            if (coordsModule.defaultColorX != null) {
                coordsModule.colorX = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_x", (Object)coordsModule.defaultColorX.getValue())));
            }
            if (coordsModule.defaultColorY != null) {
                coordsModule.colorY = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_y", (Object)coordsModule.defaultColorY.getValue())));
            }
            if (coordsModule.defaultColorZ != null) {
                coordsModule.colorZ = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_z", (Object)coordsModule.defaultColorZ.getValue())));
            }
        }
        if (baseModule instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)baseModule;
            if (fpsModule.defaultColorHigh != null) {
                fpsModule.colorHigh = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_high", (Object)fpsModule.defaultColorHigh.getValue())));
            }
            if (fpsModule.defaultColorMed != null) {
                fpsModule.colorMed = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_med", (Object)fpsModule.defaultColorMed.getValue())));
            }
            if (fpsModule.defaultColorLow != null) {
                fpsModule.colorLow = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("color_low", (Object)fpsModule.defaultColorLow.getValue())));
            }
        }
        if (baseModule instanceof EmptyModule) {
            EmptyModule emptyModule = (EmptyModule)baseModule;
            emptyModule.emptyLines = (Integer)moduleConfig.getOrElse("empty_lines", (Object)1);
        }
        if (baseModule instanceof SoundModule) {
            SoundModule soundModule = (SoundModule)baseModule;
            if (soundModule.defaultMaximumColor != null) {
                soundModule.maximumColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("maximum_color", (Object)soundModule.defaultMaximumColor.getValue())));
            }
        }
        if (baseModule instanceof EntityModule) {
            EntityModule entityModule = (EntityModule)baseModule;
            if (entityModule.defaultTotalColor != null) {
                entityModule.totalColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("total_entities_color", (Object)entityModule.defaultTotalColor.getValue())));
            }
        }
        if (baseModule instanceof HelpModule) {
            HelpModule helpModule = (HelpModule)baseModule;
            if (helpModule.defaultEnabledColor != null) {
                helpModule.enabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("enabled_color", (Object)helpModule.defaultEnabledColor.getValue())));
            }
            if (helpModule.defaultDisabledColor != null) {
                helpModule.disabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("disabled_color", (Object)helpModule.defaultDisabledColor.getValue())));
            }
        }
        if (baseModule instanceof ChunksModule) {
            ChunksModule chunkModule = (ChunksModule)baseModule;
            if (chunkModule.defaultEnabledColor != null) {
                chunkModule.enabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("chunks_enabled_color", (Object)chunkModule.defaultEnabledColor.getValue())));
            }
            if (chunkModule.defaultDisabledColor != null) {
                chunkModule.disabledColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("chunks_disabled_color", (Object)chunkModule.defaultDisabledColor.getValue())));
            }
            if (chunkModule.defaultTotalColor != null) {
                chunkModule.totalColor = TextColor.fromRgb((int)((Integer)moduleConfig.getOrElse("total_chunks_color", (Object)chunkModule.defaultTotalColor.getValue())));
            }
        }
        if (baseModule instanceof SystemModule) {
            SystemModule systemModule = (SystemModule)baseModule;
            if (systemModule.memoryColorToggle == null) {
                systemModule.memoryColorToggle = (Boolean)moduleConfig.getOrElse("memory_color_toggle", (Object)systemModule.defaultMemoryColorToggle);
            }
            if (systemModule.timeFormat == null) {
                systemModule.timeFormat = (String)moduleConfig.getOrElse("time_format", (Object)systemModule.defaultTimeFormat);
            }
        }
        baseModule.enabled = (Boolean)moduleConfig.getOrElse("enabled", (Object)true);
        return baseModule;
    }

    private static Config saveModule(BaseModule module) {
        Config moduleConfig = Config.inMemory();
        Config lines = Config.inMemory();
        for (DebugLine line : module.lines()) {
            String lineId = line.id();
            lines.set(lineId, (Object)line.enabled);
        }
        moduleConfig.set("name", (Object)module.id);
        if (module.nameColor != null) {
            moduleConfig.set("name_color", (Object)module.nameColor.getValue());
        }
        if (module.valueColor != null) {
            moduleConfig.set("value_color", (Object)module.valueColor.getValue());
        }
        if (module instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)module;
            if (coordsModule.colorX != null) {
                moduleConfig.set("color_x", (Object)coordsModule.colorX.getValue());
            }
            if (coordsModule.colorY != null) {
                moduleConfig.set("color_y", (Object)coordsModule.colorY.getValue());
            }
            if (coordsModule.colorZ != null) {
                moduleConfig.set("color_z", (Object)coordsModule.colorZ.getValue());
            }
        }
        if (module instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)module;
            if (fpsModule.colorHigh != null) {
                moduleConfig.set("color_high", (Object)fpsModule.colorHigh.getValue());
            }
            if (fpsModule.colorMed != null) {
                moduleConfig.set("color_med", (Object)fpsModule.colorMed.getValue());
            }
            if (fpsModule.colorLow != null) {
                moduleConfig.set("color_low", (Object)fpsModule.colorLow.getValue());
            }
        }
        if (module instanceof EmptyModule) {
            EmptyModule emptyModule = (EmptyModule)module;
            moduleConfig.set("empty_lines", (Object)emptyModule.emptyLines);
        }
        if (module instanceof SoundModule) {
            SoundModule soundModule = (SoundModule)module;
            if (soundModule.maximumColor != null) {
                moduleConfig.set("maximum_color", (Object)soundModule.maximumColor.getValue());
            }
        }
        if (module instanceof EntityModule) {
            EntityModule entityModule = (EntityModule)module;
            if (entityModule.totalColor != null) {
                moduleConfig.set("total_entities_color", (Object)entityModule.totalColor.getValue());
            }
        }
        if (module instanceof HelpModule) {
            HelpModule helpModule = (HelpModule)module;
            if (helpModule.enabledColor != null) {
                moduleConfig.set("enabled_color", (Object)helpModule.enabledColor.getValue());
            }
            if (helpModule.disabledColor != null) {
                moduleConfig.set("disabled_color", (Object)helpModule.disabledColor.getValue());
            }
        }
        if (module instanceof ChunksModule) {
            ChunksModule chunkModule = (ChunksModule)module;
            if (chunkModule.enabledColor != null) {
                moduleConfig.set("chunks_enabled_color", (Object)chunkModule.enabledColor.getValue());
            }
            if (chunkModule.disabledColor != null) {
                moduleConfig.set("chunks_disabled_color", (Object)chunkModule.disabledColor.getValue());
            }
            if (chunkModule.totalColor != null) {
                moduleConfig.set("total_chunks_color", (Object)chunkModule.totalColor.getValue());
            }
        }
        moduleConfig.set("enabled", (Object)module.enabled);
        moduleConfig.set("lines", (Object)lines);
        return moduleConfig;
    }

    static {
        saveRunnable = () -> {
            Path path = Paths.get(storedFileType == FileType.JSON ? "config/betterf3.json" : "config/betterf3.toml", new String[0]);
            File file = path.toFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            FileConfig config = FileConfig.builder((Path)path).concurrent().autosave().build();
            Config general = Config.inMemory();
            general.set("disable_mod", (Object)GeneralOptions.disableMod);
            general.set("auto_start", (Object)GeneralOptions.autoF3);
            general.set("space_modules", (Object)GeneralOptions.spaceEveryModule);
            general.set("shadow_text", (Object)GeneralOptions.shadowText);
            general.set("animations", (Object)GeneralOptions.enableAnimations);
            general.set("animationSpeed", (Object)GeneralOptions.animationSpeed);
            general.set("fontScale", (Object)GeneralOptions.fontScale);
            general.set("background_color", (Object)GeneralOptions.backgroundColor);
            general.set("hide_debug_crosshair", (Object)GeneralOptions.hideDebugCrosshair);
            general.set("hide_sidebar", (Object)GeneralOptions.hideSidebar);
            general.set("hide_bossbar", (Object)GeneralOptions.hideBossbar);
            general.set("always_show_profiler", (Object)GeneralOptions.alwaysEnableProfiler);
            general.set("always_show_tps", (Object)GeneralOptions.alwaysEnableTPS);
            general.set("always_show_ping", (Object)GeneralOptions.alwaysEnablePing);
            ArrayList<Config> configsLeft = new ArrayList<Config>();
            for (BaseModule module : BaseModule.modules) {
                Config moduleConfig = ModConfigFile.saveModule(module);
                configsLeft.add(moduleConfig);
            }
            ArrayList<Config> configsRight = new ArrayList<Config>();
            for (BaseModule module : BaseModule.modulesRight) {
                Config moduleConfig = ModConfigFile.saveModule(module);
                configsRight.add(moduleConfig);
            }
            config.set("modules_left", configsLeft);
            config.set("modules_right", configsRight);
            config.set("general", (Object)general);
            config.close();
        };
    }

    public static enum FileType {
        JSON,
        TOML;

    }
}

