/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.betterbeaconplacement_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.BlockFunctions;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Util {
    public static BlockPos getNextLocation(Level world, BlockPos beaconpos) {
        int x = beaconpos.getX();
        int y = beaconpos.getY();
        int z = beaconpos.getZ();
        for (int n = 1; n <= 4; ++n) {
            Iterator<BlockPos> layer = BlockPos.betweenClosedStream((int)(x - n), (int)(y - n), (int)(z - n), (int)(x + n), (int)(y - n), (int)(z + n)).iterator();
            BlockPos result = Util.checkIterator(world, layer);
            if (result == null) continue;
            if (BlockFunctions.isSpecificBlock((Block)Blocks.BEDROCK, (Level)world, (BlockPos)result).booleanValue()) {
                return null;
            }
            return result;
        }
        return null;
    }

    public static void processAllBaseBlocks(Level world, BlockPos beaconpos, boolean iscreative) {
        int x = beaconpos.getX();
        int y = beaconpos.getY();
        int z = beaconpos.getZ();
        for (int n = 1; n <= 4; ++n) {
            Util.breakBase(world, beaconpos, BlockPos.betweenClosedStream((int)(x - n), (int)(y - n), (int)(z - n), (int)(x + n), (int)(y - n), (int)(z + n)).iterator(), iscreative);
        }
    }

    public static void breakBase(Level world, BlockPos beaconpos, Iterator<BlockPos> it, boolean iscreative) {
        while (it.hasNext()) {
            BlockPos np = it.next();
            BlockState blockState = world.getBlockState(np);
            if (!blockState.is(BlockTags.BEACON_BASE_BLOCKS)) continue;
            world.setBlockAndUpdate(np, Blocks.AIR.defaultBlockState());
            if (iscreative) continue;
            ItemEntity ei = new ItemEntity(world, (double)beaconpos.getX(), (double)(beaconpos.getY() + 2), (double)beaconpos.getZ(), new ItemStack((ItemLike)blockState.getBlock(), 1));
            world.addFreshEntity((Entity)ei);
        }
    }

    private static BlockPos checkIterator(Level world, Iterator<BlockPos> it) {
        while (it.hasNext()) {
            BlockPos np = it.next();
            BlockState blockState = world.getBlockState(np);
            if (blockState.is(BlockTags.BEACON_BASE_BLOCKS)) continue;
            return np.immutable();
        }
        return null;
    }
}

