/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.chorusfruitdropsnearby_common_forge.events;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ChorusEvent {
    private static final CopyOnWriteArrayList<BlockPos> lastChorusBlock = new CopyOnWriteArrayList();
    private static final HashMap<BlockPos, Date> lastAction = new HashMap();

    public static void onChorusFruit(Level level, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        ItemStack itemstack = itemEntity.getItem();
        if (!itemstack.getItem().equals(Items.CHORUS_FRUIT)) {
            return;
        }
        Date now = new Date();
        BlockPos chorusPos = entity.blockPosition();
        BlockPos lowChorusPos = new BlockPos(chorusPos.getX(), 1, chorusPos.getZ());
        for (BlockPos lspos : lastChorusBlock) {
            if (lastAction.containsKey(lspos)) {
                Date lastdate = lastAction.get(lspos);
                long ms = now.getTime() - lastdate.getTime();
                if (ms > 2000L) {
                    lastChorusBlock.remove(lspos);
                    lastAction.remove(lspos);
                    continue;
                }
            }
            if (!lowChorusPos.closerThan((Vec3i)new BlockPos(lspos.getX(), 1, lspos.getZ()), 20.0)) continue;
            entity.teleportTo((double)lspos.getX(), (double)(lspos.getY() + 1), (double)lspos.getZ());
            lastAction.put(lspos.immutable(), now);
        }
    }

    public static void onBlockBreak(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        Block block = state.getBlock();
        if (block.equals(Blocks.CHORUS_PLANT)) {
            lastChorusBlock.add(pos);
            lastAction.put(pos, new Date());
        }
    }
}

