/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.world.item;

import fuzs.permanentsponges.PermanentSponges;
import fuzs.permanentsponges.config.ServerConfig;
import fuzs.permanentsponges.world.level.block.PermanentSpongeBlock;
import fuzs.permanentsponges.world.level.block.SpongeMaterial;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SpongeOnAStickItem
extends Item {
    private final SpongeMaterial spongeMaterial;

    public SpongeOnAStickItem(Item.Properties properties, SpongeMaterial spongeMaterial) {
        super(properties);
        this.spongeMaterial = spongeMaterial;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = SpongeOnAStickItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (!level.mayInteract(player, blockPos) || !player.mayUseItemAt(blockPos2, direction, itemStack)) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            int cooldownTicks = ((ServerConfig)PermanentSponges.CONFIG.get(ServerConfig.class)).stickCooldownTicks;
            if (cooldownTicks > 0) {
                player.getCooldowns().addCooldown((Item)this, cooldownTicks);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (PermanentSpongeBlock.removeAllLiquid(this.spongeMaterial, serverLevel, blockPos, true)) {
                    itemStack.setDamageValue(itemStack.getMaxDamage() - 1);
                }
                ItemHelper.hurtAndBreak((ItemStack)itemStack, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            bucketPickup.getPickupSound().ifPresent(soundEvent -> player.playSound(soundEvent, 1.0f, 1.0f));
            level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, blockPos);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }
}

