/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.util;

import com.google.common.base.Predicates;
import fuzs.permanentsponges.core.CommonAbstractions;
import fuzs.permanentsponges.init.ModRegistry;
import fuzs.permanentsponges.world.level.block.SpongeMaterial;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class LiquidAbsorptionHelper {
    private static final Int2ObjectMap<List<BlockPos>> SPONGE_RADIUS = new Int2ObjectOpenHashMap();

    public static List<BlockPos> getSpongeRadius(int depth) {
        return (List)SPONGE_RADIUS.computeIfAbsent(depth, LiquidAbsorptionHelper::getSortedSpongeRadius);
    }

    private static List<BlockPos> getSortedSpongeRadius(int depth) {
        return BlockPos.betweenClosedStream((int)(-depth), (int)(-depth), (int)(-depth), (int)depth, (int)depth, (int)depth).map(BlockPos::immutable).sorted(Comparator.comparingInt(blockPos -> Math.max(Math.max(Math.abs(blockPos.getX()), Math.abs(blockPos.getY())), Math.abs(blockPos.getZ()))).thenComparingInt(arg_0 -> ((BlockPos)BlockPos.ZERO).distManhattan(arg_0))).toList();
    }

    public static boolean removeAllLiquid(ServerLevel level, BlockPos blockPos, int spongeRadius, boolean destroySource) {
        List<BlockPos> positions = LiquidAbsorptionHelper.getSpongeRadius(spongeRadius);
        BoundingBox boundingBox = new BoundingBox(-spongeRadius, -spongeRadius, -spongeRadius, spongeRadius, spongeRadius, spongeRadius);
        level.getFluidTicks().clearArea(boundingBox.move((Vec3i)blockPos));
        boolean hasDestroyedSource = false;
        for (BlockPos currentBlockPos : positions) {
            currentBlockPos = blockPos.offset((Vec3i)currentBlockPos);
            BlockState blockState = level.getBlockState(currentBlockPos);
            FluidState fluidState = level.getFluidState(currentBlockPos);
            if (fluidState.isEmpty() && !blockState.isAir()) continue;
            if (!hasDestroyedSource && CommonAbstractions.INSTANCE.isHotFluid(fluidState.getType())) {
                if (destroySource) {
                    LiquidAbsorptionHelper.destroySpongeBlock(level, blockPos);
                }
                hasDestroyedSource = true;
            }
            LiquidAbsorptionHelper.removeLiquid((Level)level, currentBlockPos, blockState, fluidState);
        }
        return hasDestroyedSource;
    }

    private static void destroySpongeBlock(ServerLevel level, BlockPos blockPos) {
        if (level.getBlockState(blockPos).is(ModRegistry.PERMANENT_SPONGES_BLOCK_TAG)) {
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
            level.levelEvent(2009, blockPos, 0);
            level.playSound(null, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }

    private static void removeLiquid(Level level, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (!(blockState.getBlock() instanceof BucketPickup) || ((BucketPickup)blockState.getBlock()).pickupBlock(null, (LevelAccessor)level, blockPos, blockState).isEmpty()) {
            boolean setToAir = false;
            if (blockState.getBlock() instanceof LiquidBlock || blockState.isAir()) {
                setToAir = true;
            } else if (blockState.is(Blocks.KELP) || blockState.is(Blocks.KELP_PLANT) || blockState.is(Blocks.SEAGRASS) || blockState.is(Blocks.TALL_SEAGRASS)) {
                BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(blockPos) : null;
                Block.dropResources((BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos, (BlockEntity)blockEntity);
                setToAir = true;
            }
            if (setToAir && !blockState.isAir()) {
                level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
                if (!fluidState.isEmpty() && level.getRandom().nextInt(5) == 0) {
                    LiquidAbsorptionHelper.removeLiquidEffects(level, blockPos, fluidState.getType());
                }
            }
        }
    }

    public static void removeLiquidEffects(Level level, BlockPos blockPos, Fluid fluid) {
        if (CommonAbstractions.INSTANCE.isHotFluid(fluid)) {
            level.levelEvent(1501, blockPos, 0);
        } else {
            level.levelEvent(2009, blockPos, 0);
            level.playSound(null, blockPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }

    public static boolean tryPreventLiquidFromEntering(ServerLevel serverLevel, BlockPos pos, Fluid fluid) {
        Map.Entry<SpongeMaterial, BlockPos> entry = LiquidAbsorptionHelper.keepPositionFreeFromLiquid(serverLevel, pos);
        if (entry != null) {
            if (entry.getKey().shouldDestroyTouchingHot() && CommonAbstractions.INSTANCE.isHotFluid(fluid)) {
                LiquidAbsorptionHelper.destroySpongeBlock(serverLevel, entry.getValue());
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static Map.Entry<SpongeMaterial, BlockPos> keepPositionFreeFromLiquid(ServerLevel serverLevel, BlockPos blockPos) {
        if (blockPos != null) {
            PoiManager poiManager = serverLevel.getPoiManager();
            for (SpongeMaterial spongeMaterial : SpongeMaterial.values()) {
                ResourceKey resourceKey = spongeMaterial.getPoiType().key();
                int distance = (int)Math.ceil((double)(spongeMaterial.getBlockDistance() + 1) * 1.42);
                Optional<BlockPos> optional = poiManager.findAll(holder -> holder.is(resourceKey), (Predicate)Predicates.alwaysTrue(), blockPos, distance, PoiManager.Occupancy.ANY).filter(currentBlockPos -> Math.abs((currentBlockPos = currentBlockPos.subtract((Vec3i)blockPos)).getX()) <= spongeMaterial.getBlockDistance() && Math.abs(currentBlockPos.getY()) <= spongeMaterial.getBlockDistance() && Math.abs(currentBlockPos.getZ()) <= spongeMaterial.getBlockDistance()).min(Comparator.comparingInt(arg_0 -> ((BlockPos)blockPos).distManhattan(arg_0)));
                if (!optional.isPresent()) continue;
                return Map.entry(spongeMaterial, optional.get());
            }
        }
        return null;
    }
}

