/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.VertexAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CCRenderPipeline {
    private final CCRenderState renderState;
    @Deprecated
    public boolean forceFormatAttributes = true;
    private final List<VertexAttribute<?>> attribs = new ArrayList();
    private final List<IVertexOperation> ops = new ArrayList<IVertexOperation>();
    private final List<PipelineNode> nodes = new ArrayList<PipelineNode>();
    private final List<IVertexOperation> sorted = new ArrayList<IVertexOperation>();
    @Nullable
    private PipelineNode loading;

    public CCRenderPipeline(CCRenderState renderState) {
        this.renderState = renderState;
    }

    public void setPipeline(IVertexOperation ... ops) {
        this.ops.clear();
        Collections.addAll(this.ops, ops);
        this.rebuild();
    }

    public void reset() {
        this.ops.clear();
        this.unbuild();
    }

    private void unbuild() {
        for (int i = 0; i < this.attribs.size(); ++i) {
            VertexAttribute<?> attrib = this.attribs.get(i);
            attrib.active = false;
        }
        this.attribs.clear();
        this.sorted.clear();
    }

    public void rebuild() {
        int i;
        if (this.renderState.model == null || this.renderState.fmt == null) {
            return;
        }
        this.unbuild();
        assert (this.renderState.cFmt != null);
        if (this.renderState.cFmt.hasNormal) {
            this.addAttribute(this.renderState.normalAttrib);
        }
        if (this.renderState.cFmt.hasColor) {
            this.addAttribute(this.renderState.colourAttrib);
        }
        if (this.renderState.computeLighting && !this.renderState.hackyReallyDontComputeLighting) {
            this.addAttribute(this.renderState.lightingAttrib);
        }
        if (this.ops.isEmpty()) {
            return;
        }
        while (this.nodes.size() < IVertexOperation.operationCount()) {
            this.nodes.add(new PipelineNode());
        }
        for (i = 0; i < this.ops.size(); ++i) {
            IVertexOperation op = this.ops.get(i);
            this.loading = this.nodes.get(op.operationID());
            assert (this.loading != null);
            boolean loaded = op.load(this.renderState);
            if (loaded) {
                this.loading.op = op;
            }
            if (!(op instanceof VertexAttribute)) continue;
            if (loaded) {
                this.attribs.add((VertexAttribute)op);
                continue;
            }
            ((VertexAttribute)op).active = false;
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            PipelineNode node = this.nodes.get(i);
            node.add();
        }
    }

    public void addRequirement(int opRef) {
        assert (this.loading != null);
        this.loading.deps.add(this.nodes.get(opRef));
    }

    public void addDependency(VertexAttribute<?> attrib) {
        assert (this.loading != null);
        this.loading.deps.add(this.nodes.get(attrib.operationID()));
        this.addAttribute(attrib);
    }

    public void addAttribute(VertexAttribute<?> attrib) {
        if (!attrib.active) {
            this.ops.add(attrib);
            attrib.active = true;
        }
    }

    public void operate() {
        for (int i = 0; i < this.sorted.size(); ++i) {
            IVertexOperation aSorted = this.sorted.get(i);
            aSorted.operate(this.renderState);
        }
    }

    private class PipelineNode {
        public ArrayList<PipelineNode> deps = new ArrayList();
        @Nullable
        public IVertexOperation op;

        private PipelineNode() {
        }

        public void add() {
            if (this.op == null) {
                return;
            }
            for (int i = 0; i < this.deps.size(); ++i) {
                PipelineNode dep = this.deps.get(i);
                dep.add();
            }
            this.deps.clear();
            CCRenderPipeline.this.sorted.add(this.op);
            this.op = null;
        }
    }
}

