/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block;

import java.util.LinkedHashMap;
import java.util.Map;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class LazyStateBlock
extends Block {
    private final Map<Property<?>, Comparable<?>> propMap = new LinkedHashMap();
    private boolean computedState = false;

    public LazyStateBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected final <T extends Comparable<T>, V extends T> void addProperty(Property<T> prop, V default_) {
        if (this.computedState) {
            throw new IllegalStateException("State has already been computed.");
        }
        this.propMap.put(prop, (Comparable<?>)default_);
    }

    protected BlockState processDefault(BlockState state) {
        return state;
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        this.computeState();
        return super.getStateDefinition();
    }

    public BlockState defaultBlockState() {
        this.computeState();
        return super.defaultBlockState();
    }

    private void computeState() {
        BlockState defaultState;
        if (this.computedState) {
            return;
        }
        if (!this.propMap.isEmpty()) {
            StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
            this.propMap.keySet().forEach(xva$0 -> builder.add(new Property[]{xva$0}));
            this.stateDefinition = builder.create(Block::defaultBlockState, BlockState::new);
            defaultState = (BlockState)this.stateDefinition.any();
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.propMap.entrySet()) {
                defaultState = (BlockState)defaultState.setValue(entry.getKey(), (Comparable)SneakyUtils.unsafeCast(entry.getValue()));
            }
        } else {
            defaultState = (BlockState)this.stateDefinition.any();
        }
        this.registerDefaultState(this.processDefault(defaultState));
        this.computedState = true;
        this.propMap.clear();
    }

    protected final void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
    }
}

