/*
 * Decompiled with CFR 0.152.
 */
package fuzs.effectdescriptions.client.handler;

import fuzs.effectdescriptions.EffectDescriptions;
import fuzs.effectdescriptions.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import org.jetbrains.annotations.Nullable;

public class FoodTooltipHandler {
    public static void onItemTooltip(ItemStack itemStack, List<Component> lines, Item.TooltipContext tooltipContext, @Nullable Player player, TooltipFlag tooltipFlag) {
        if (!((ClientConfig)EffectDescriptions.CONFIG.get(ClientConfig.class)).foodEffects) {
            return;
        }
        if (itemStack.has(DataComponents.FOOD)) {
            FoodProperties foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD);
            ArrayList effectLines = new ArrayList();
            for (FoodProperties.PossibleEffect effect : foodProperties.effects()) {
                float[] effectProbability = new float[]{effect.probability()};
                PotionContents.addPotionTooltip(Collections.singleton(effect.effect()), component -> {
                    if (effectProbability[0] != 1.0f) {
                        int intEffectProbability = Mth.floor((float)(effectProbability[0] * 100.0f));
                        component = Component.empty().append(component).append(" (" + intEffectProbability + "%)").withStyle(ChatFormatting.GOLD);
                        effectProbability[0] = 1.0f;
                    }
                    effectLines.add(component);
                }, (float)1.0f, (float)tooltipContext.tickRate());
            }
            if (lines.isEmpty()) {
                lines.addAll(effectLines);
            } else {
                lines.addAll(1, effectLines);
            }
        }
    }
}

