/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.ExtendedSlopePanelShapes;

public final class FlatExtendedSlopePanelCornerShapes
implements SplitShapeGenerator {
    private static final ShapeCache<ShapeKey> FINAL_SHAPES = FlatExtendedSlopePanelCornerShapes.makeCache(ExtendedSlopePanelShapes.SHAPES, BooleanOp.AND);
    private static final ShapeCache<ShapeKey> FINAL_OCCLUSION_SHAPES = FlatExtendedSlopePanelCornerShapes.makeCache(ExtendedSlopePanelShapes.OCCLUSION_SHAPES, BooleanOp.AND);
    private static final ShapeCache<ShapeKey> FINAL_INNER_SHAPES = FlatExtendedSlopePanelCornerShapes.makeCache(ExtendedSlopePanelShapes.SHAPES, BooleanOp.OR);
    private static final ShapeCache<ShapeKey> FINAL_INNER_OCCLUSION_SHAPES = FlatExtendedSlopePanelCornerShapes.makeCache(ExtendedSlopePanelShapes.OCCLUSION_SHAPES, BooleanOp.OR);
    public static final FlatExtendedSlopePanelCornerShapes OUTER = new FlatExtendedSlopePanelCornerShapes(FINAL_SHAPES, FINAL_OCCLUSION_SHAPES);
    public static final FlatExtendedSlopePanelCornerShapes INNER = new FlatExtendedSlopePanelCornerShapes(FINAL_INNER_SHAPES, FINAL_INNER_OCCLUSION_SHAPES);
    private final ShapeCache<ShapeKey> shapes;
    private final ShapeCache<ShapeKey> occlusionShapes;

    private FlatExtendedSlopePanelCornerShapes(ShapeCache<ShapeKey> shapes, ShapeCache<ShapeKey> occlusionShapes) {
        this.shapes = shapes;
        this.occlusionShapes = occlusionShapes;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return FlatExtendedSlopePanelCornerShapes.generate(states, this.shapes);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return FlatExtendedSlopePanelCornerShapes.generate(states, this.occlusionShapes);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            builder.put((Object)state, (Object)cache.get(new ShapeKey(dir, rot)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<ShapeKey> makeCache(ShapeCache<HorizontalRotation> cache, BooleanOp joinOp) {
        return ShapeCache.create(map -> {
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape shape = Shapes.joinUnoptimized((VoxelShape)cache.get(rot), (VoxelShape)cache.get(rot.rotate(Rotation.COUNTERCLOCKWISE_90)), (BooleanOp)joinOp);
                ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map, rot, ShapeKey::new);
            }
        });
    }

    private record ShapeKey(Direction dir, HorizontalRotation rot) {
    }
}

