/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.slopeedge;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public final class ElevatedSlopeEdgeConnectionPredicate
implements ConnectionPredicate {
    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = dir.getCounterClockWise();
                break;
            }
            case TOP: {
                Direction direction = dirTwo = Direction.UP;
            }
        }
        if (side == dir || side == dirTwo) {
            return true;
        }
        if (side == dir.getOpposite()) {
            return edge == dirTwo;
        }
        if (side == dirTwo.getOpposite()) {
            return edge == dir;
        }
        if (side.getAxis() != dir.getAxis() && side.getAxis() != dirTwo.getAxis()) {
            return edge == dir || edge == dirTwo;
        }
        return false;
    }

    @Override
    public boolean canConnectDetailed(BlockState state, Direction side, Direction edge) {
        Direction dirTwo;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = dir.getCounterClockWise();
                break;
            }
            case TOP: {
                Direction direction = dirTwo = Direction.UP;
            }
        }
        if (side.getAxis() != dir.getAxis() && side.getAxis() != dirTwo.getAxis()) {
            return edge == dir.getOpposite() || edge == dirTwo.getOpposite();
        }
        if (type == SlopeType.HORIZONTAL) {
            if (side == dir.getOpposite()) {
                return Utils.isY(edge) || edge == dirTwo.getOpposite();
            }
            if (side == dirTwo.getOpposite()) {
                return Utils.isY(edge) || edge == dir.getOpposite();
            }
        } else {
            if (side == dir.getOpposite()) {
                return edge.getAxis() == dir.getClockWise().getAxis() || edge == dirTwo.getOpposite();
            }
            if (side == dirTwo.getOpposite()) {
                return edge.getAxis() == dir.getClockWise().getAxis() || edge == dir.getOpposite();
            }
        }
        return false;
    }
}

