/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.rei;

import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import xfacthd.framedblocks.client.screen.FramingSawWithEncoderScreen;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

public final class FramingSawDraggableStackVisitor
implements DraggableStackVisitor<FramingSawWithEncoderScreen> {
    public <R extends Screen> boolean isHandingScreen(R screen) {
        FramingSawWithEncoderScreen encoder;
        return screen instanceof FramingSawWithEncoderScreen && (encoder = (FramingSawWithEncoderScreen)screen).getMenu().isInEncoderMode();
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<FramingSawWithEncoderScreen> context, DraggableStack draggableStack) {
        Object object = draggableStack.getStack().getValue();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            FramingSawWithEncoderScreen screen = (FramingSawWithEncoderScreen)context.getScreen();
            if (FramingSawRecipeCache.get(true).getMaterialValue(stack.getItem()) > 0) {
                return Stream.of(DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(screen.getInputSlotX() - 1, screen.getInputSlotY(0) - 1, 18, 18)));
            }
            RecipeHolder<FramingSawRecipe> recipe = screen.getMenu().getRecipes().get(screen.getMenu().getSelectedRecipeIndex()).toVanilla();
            List<FramingSawRecipeAdditive> additives = ((FramingSawRecipe)recipe.value()).getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                if (!additives.get(i).ingredient().test(stack)) continue;
                return Stream.of(DraggableStackVisitor.BoundsProvider.ofRectangle((Rectangle)new Rectangle(screen.getInputSlotX() - 1, screen.getInputSlotY(i + 1) - 1, 18, 18)));
            }
        }
        return Stream.empty();
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<FramingSawWithEncoderScreen> context, DraggableStack draggableStack) {
        Object object;
        Point pos = context.getCurrentPosition();
        if (pos != null && (object = draggableStack.getStack().getValue()) instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            FramingSawWithEncoderScreen screen = (FramingSawWithEncoderScreen)context.getScreen();
            if (FramingSawRecipeCache.get(true).getMaterialValue(stack.getItem()) > 0) {
                int sx = screen.getInputSlotX();
                int sy = screen.getInputSlotY(0);
                if (pos.x >= sx && pos.x < sx + 18 && pos.y >= sy && pos.y < sy + 18) {
                    screen.acceptEncodingInput(0, stack);
                    return DraggedAcceptorResult.ACCEPTED;
                }
            }
            RecipeHolder<FramingSawRecipe> recipe = screen.getMenu().getRecipes().get(screen.getMenu().getSelectedRecipeIndex()).toVanilla();
            List<FramingSawRecipeAdditive> additives = ((FramingSawRecipe)recipe.value()).getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                int sx = screen.getInputSlotX();
                int sy = screen.getInputSlotY(i + 1);
                if (pos.x < sx || pos.x >= sx + 18 || pos.y < sy || pos.y >= sy + 18 || !additives.get(i).ingredient().test(stack)) continue;
                screen.acceptEncodingInput(i + 1, stack);
                return DraggedAcceptorResult.ACCEPTED;
            }
        }
        return DraggedAcceptorResult.PASS;
    }
}

