/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei.camo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.common.FBContent;

public final class CamoItemStackHelper {
    @Nullable
    public static CamoContainerFactory<?> getCamoContainerFactory(ItemStack itemStack) {
        CamoContainerFactory<?> factory = CamoContainerHelper.findCamoFactory(itemStack);
        if (factory == null || !factory.canApplyInCraftingRecipe(itemStack)) {
            return null;
        }
        return factory;
    }

    @Nullable
    public static IFramedBlock getFramedBlock(ItemStack itemStack) {
        BlockItem item;
        Item item2 = itemStack.getItem();
        if (item2 instanceof BlockItem && (item2 = (item = (BlockItem)item2).getBlock()) instanceof IFramedBlock) {
            IFramedBlock framedBlock = (IFramedBlock)item2;
            return framedBlock;
        }
        return null;
    }

    public static boolean isDoubleFramedBlock(ItemStack itemStack) {
        IFramedBlock framedBlock = CamoItemStackHelper.getFramedBlock(itemStack);
        return framedBlock != null && CamoItemStackHelper.isDoubleFramedBlock(framedBlock);
    }

    public static boolean isDoubleFramedBlock(IFramedBlock framedBlock) {
        return framedBlock.getBlockType().consumesTwoCamosInCamoApplicationRecipe();
    }

    public static boolean isEmptyFramedBlock(ItemStack itemStack) {
        IFramedBlock framedBlock = CamoItemStackHelper.getFramedBlock(itemStack);
        if (framedBlock == null) {
            return false;
        }
        CamoList camos = (CamoList)itemStack.getOrDefault(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY);
        return camos.isEmptyOrContentsEmpty();
    }

    public static List<ItemStack> dropCamo(ItemStack itemStack) {
        CamoList camos = (CamoList)itemStack.getOrDefault(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.EMPTY);
        if (camos.isEmptyOrContentsEmpty()) {
            return List.of();
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (CamoContainer<?, ?> camoContainer : camos) {
            if (!camoContainer.canTriviallyConvertToItemStack()) {
                return List.of();
            }
            ItemStack dropped = CamoContainerHelper.dropCamo(camoContainer);
            results.add(dropped);
        }
        return results;
    }

    private CamoItemStackHelper() {
    }
}

