/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedFlatStackedSlopeSlabCornerBlock
extends AbstractFramedDoubleBlock {
    private final boolean corner;

    public FramedFlatStackedSlopeSlabCornerBlock(BlockType type) {
        super(type);
        this.corner = type == BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction dir;
        Direction face = hit.getDirection();
        if (face == (dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR)).getOpposite() || face == dir.getClockWise()) {
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            Vec3 vec = Utils.fraction(hit.getLocation());
            if (this.getBlockType() == BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER) {
                if (vec.y > 0.5 != top) {
                    face = Direction.UP;
                }
            } else {
                double hor;
                Direction perpDir = face == dir.getClockWise() ? dir : dir.getCounterClockWise();
                double d = hor = Utils.isX(perpDir) ? vec.x() : vec.z();
                if (!Utils.isPositive(perpDir)) {
                    hor = 1.0 - hor;
                }
                double y = vec.y();
                if (top) {
                    y = 1.0 - y;
                }
                if ((y -= 0.5) * 2.0 >= hor) {
                    face = Direction.UP;
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)FramedProperties.TOP);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        Block topBlock = this.getBlockType() == BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER ? (Block)FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER.value() : (Block)FBContent.BLOCK_FRAMED_FLAT_SLOPE_SLAB_CORNER.value();
        return new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB.value()).defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)topBlock.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(!top))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (((Boolean)state.getValue((Property)FramedProperties.TOP)).booleanValue()) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing;
        Direction dirTwo;
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dirTwo || !Utils.isY(side) && edge == dirTwo) {
            return CamoGetter.FIRST;
        }
        if (!(this.corner || edge != dirTwo.getOpposite() || side != (facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR)) && side != facing.getCounterClockWise())) {
            return CamoGetter.SECOND;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing;
        boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return SolidityCheck.FIRST;
        }
        if (!(this.corner || side != (facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR)) && side != facing.getCounterClockWise())) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }
}

