/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pillar.FramedPillarGeometry;

public class FramedHalfPillarGeometry
extends Geometry {
    private final Direction face;

    public FramedHalfPillarGeometry(GeometryFactory.Context ctx) {
        this.face = (Direction)ctx.state().getValue((Property)BlockStateProperties.FACING);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        QuadModifier mod = FramedPillarGeometry.createPillarQuad(quad, this.face.getAxis(), 0.25f, 0.75f, 0.75f);
        if (mod.hasFailed()) {
            return;
        }
        Direction quadDir = quad.getDirection();
        if (quadDir == this.face) {
            mod.export(quadMap.get(this.face));
        } else if (quadDir == this.face.getOpposite()) {
            mod.apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else if (Utils.isY(this.face)) {
            mod.apply(Modifiers.cutSideUpDown(this.face == Direction.UP, 0.5f)).export(quadMap.get(null));
        } else if (Utils.isY(quadDir)) {
            mod.apply(Modifiers.cutTopBottom(this.face.getOpposite(), 0.5f)).export(quadMap.get(null));
        } else {
            mod.apply(Modifiers.cutSideLeftRight(this.face.getOpposite(), 0.5f)).export(quadMap.get(null));
        }
    }
}

