/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedWallHangingSignGeometry
extends Geometry {
    private final BlockState state;
    private final BakedModel baseModel;
    private final Direction dir;

    public FramedWallHangingSignGeometry(GeometryFactory.Context ctx) {
        this.state = ctx.state();
        this.baseModel = ctx.baseModel();
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir.getAxis() == this.dir.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.625f)).apply(Modifiers.cutSideLeftRight(0.9375f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.125f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        } else if (quadDir.getAxis() == this.dir.getClockWise().getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, 0.625f)).apply(Modifiers.cutSideLeftRight(0.5625f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, 0.125f)).apply(Modifiers.cutSideLeftRight(0.625f)).export(quadMap.get(quadDir));
        } else {
            boolean up = quadDir == Direction.UP;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getAxis(), 0.5625f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise().getAxis(), 0.9375f)).applyIf(Modifiers.setPosition(0.625f), up).export(quadMap.get(up ? null : quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getAxis(), 0.625f)).applyIf(Modifiers.setPosition(0.125f), !up).export(quadMap.get((Direction)(up ? quadDir : null)));
        }
    }

    @Override
    public ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ModelUtils.CUTOUT;
    }

    @Override
    public void getAdditionalQuads(QuadMap quadMap, RandomSource rand, ModelData data, RenderType renderType) {
        if (renderType == RenderType.cutout()) {
            Utils.forAllDirections(dir -> quadMap.get((Direction)dir).addAll(this.baseModel.getQuads(this.state, dir, rand, data, renderType)));
        }
    }
}

