/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerTubeOrientation;

public class FramedCornerTubeGeometry
extends Geometry {
    private final CornerTubeOrientation orientation;
    private final float minWidth;
    private final float maxWidth;

    public FramedCornerTubeGeometry(GeometryFactory.Context ctx) {
        this.orientation = (CornerTubeOrientation)((Object)ctx.state().getValue(PropertyHolder.CORNER_TYPE_ORIENTATION));
        float thickness = (Boolean)ctx.state().getValue((Property)PropertyHolder.THICK) != false ? 3.0f : 2.0f;
        this.minWidth = thickness / 16.0f;
        this.maxWidth = (16.0f - thickness) / 16.0f;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(quadDir)) {
            if (this.orientation.isSideOpen(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.NORTH, this.minWidth)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.SOUTH, this.minWidth)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.EAST, this.minWidth)).apply(Modifiers.cutTopBottom(Direction.Axis.Z, this.maxWidth)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.WEST, this.minWidth)).apply(Modifiers.cutTopBottom(Direction.Axis.Z, this.maxWidth)).export(quadMap.get(quadDir));
                QuadModifier mod = QuadModifier.of(quad);
                for (Direction side : Direction.values()) {
                    if (side.getAxis() == quadDir.getAxis() || this.orientation.isSideOpen(side)) continue;
                    mod.apply(Modifiers.cutTopBottom(side, this.maxWidth));
                }
                mod.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
            } else if (this.orientation.isSideOpen(quadDir.getOpposite())) {
                QuadModifier mod = QuadModifier.of(quad);
                for (Direction side : Direction.values()) {
                    if (side.getAxis() == quadDir.getAxis()) continue;
                    if (this.orientation.isSideOpen(side.getOpposite())) {
                        mod.apply(Modifiers.cutTopBottom(side, this.minWidth));
                        continue;
                    }
                    if (this.orientation.isSideOpen(side)) continue;
                    mod.apply(Modifiers.cutTopBottom(side, this.maxWidth));
                }
                mod.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
            } else {
                QuadModifier modOne = QuadModifier.of(quad);
                QuadModifier modTwo = QuadModifier.of(quad);
                for (Direction side : Direction.values()) {
                    if (side.getAxis() == quadDir.getAxis()) continue;
                    if (side != this.orientation.getPrimaryDir()) {
                        modOne.apply(Modifiers.cutTopBottom(side, this.maxWidth));
                    }
                    if (side == this.orientation.getSecondaryDir()) continue;
                    float len = side == this.orientation.getSecondaryDir().getOpposite() ? this.minWidth : this.maxWidth;
                    modTwo.apply(Modifiers.cutTopBottom(side, len));
                }
                modOne.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
                modTwo.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
            }
        } else if (this.orientation.isSideOpen(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, this.minWidth)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, this.minWidth)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getClockWise(), this.minWidth)).apply(Modifiers.cutSideUpDown(this.maxWidth)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getCounterClockWise(), this.minWidth)).apply(Modifiers.cutSideUpDown(this.maxWidth)).export(quadMap.get(quadDir));
            QuadModifier mod = QuadModifier.of(quad);
            for (Direction side : Direction.values()) {
                if (side.getAxis() == quadDir.getAxis() || this.orientation.isSideOpen(side)) continue;
                mod.apply(Modifiers.cutSide(side, this.maxWidth, this.maxWidth));
            }
            mod.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
        } else if (this.orientation.isSideOpen(quadDir.getOpposite())) {
            QuadModifier mod = QuadModifier.of(quad);
            for (Direction side : Direction.values()) {
                if (side.getAxis() == quadDir.getAxis()) continue;
                if (this.orientation.isSideOpen(side.getOpposite())) {
                    mod.apply(Modifiers.cutSide(side, this.minWidth, this.minWidth));
                    continue;
                }
                if (this.orientation.isSideOpen(side)) continue;
                mod.apply(Modifiers.cutSide(side, this.maxWidth, this.maxWidth));
            }
            mod.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
        } else {
            QuadModifier modOne = QuadModifier.of(quad);
            QuadModifier modTwo = QuadModifier.of(quad);
            for (Direction side : Direction.values()) {
                if (side.getAxis() == quadDir.getAxis()) continue;
                if (side != this.orientation.getPrimaryDir()) {
                    modOne.apply(Modifiers.cutSide(side, this.maxWidth, this.maxWidth));
                }
                if (side == this.orientation.getSecondaryDir()) continue;
                float len = side == this.orientation.getSecondaryDir().getOpposite() ? this.minWidth : this.maxWidth;
                modTwo.apply(Modifiers.cutSide(side, len, len));
            }
            modOne.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
            modTwo.apply(Modifiers.setPosition(this.minWidth)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean transformAllQuads() {
        return true;
    }
}

