/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.ConcatenatedListView;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.blockentity.IFramedDoubleBlockEntity;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContent;
import xfacthd.framedblocks.api.model.AbstractFramedBlockModel;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockStateCache;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.NullCullPredicate;

public final class FramedDoubleBlockModel
extends AbstractFramedBlockModel {
    private static final ModelData EMPTY_FRAME = FramedDoubleBlockModel.makeDefaultData(false);
    private static final ModelData EMPTY_ALT_FRAME = FramedDoubleBlockModel.makeDefaultData(true);
    private final DoubleBlockTopInteractionMode particleMode;
    private final Tuple<BlockState, BlockState> dummyStates;
    private final boolean canCullLeft;
    private final boolean canCullRight;
    private Tuple<BakedModel, BakedModel> models = null;

    public FramedDoubleBlockModel(GeometryFactory.Context ctx, NullCullPredicate cullPredicate, ItemModelInfo itemModelInfo) {
        super(ctx.baseModel(), ctx.state(), itemModelInfo);
        BlockState state = ctx.state();
        DoubleBlockStateCache cache = ((IFramedDoubleBlock)state.getBlock()).getCache(state);
        this.dummyStates = cache.getBlockPair();
        this.particleMode = cache.getTopInteractionMode();
        this.canCullLeft = cullPredicate.testLeft(state);
        this.canCullRight = cullPredicate.testRight(state);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType layer) {
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)extraData.get(IFramedDoubleBlockEntity.DATA_ONE), EMPTY_FRAME);
        ModelData dataRight = Objects.requireNonNullElse((ModelData)extraData.get(IFramedDoubleBlockEntity.DATA_TWO), EMPTY_ALT_FRAME);
        boolean leftVisible = true;
        boolean rightVisible = true;
        if (side == null) {
            if (this.canCullLeft && FramedDoubleBlockModel.hasSolidCamo(dataRight)) {
                leftVisible = false;
            }
            if (this.canCullRight && FramedDoubleBlockModel.hasSolidCamo(dataLeft)) {
                rightVisible = false;
            }
            if (!leftVisible && !rightVisible) {
                return List.of();
            }
        }
        ArrayList<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(2);
        Tuple<BakedModel, BakedModel> models = this.getModels();
        if (leftVisible) {
            quads.add(((BakedModel)models.getA()).getQuads((BlockState)this.dummyStates.getA(), side, rand, dataLeft, layer));
        }
        if (rightVisible) {
            quads.add(FramedDoubleBlockModel.invertTintIndizes(((BakedModel)models.getB()).getQuads((BlockState)this.dummyStates.getB(), side, rand, dataRight, layer)));
        }
        return ConcatenatedListView.of(quads);
    }

    private static boolean hasSolidCamo(ModelData data) {
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        return fbData != null && fbData.getCamoContent().isSolid((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO);
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, RenderType.cutout());
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return switch (this.particleMode) {
            default -> throw new MatchException(null, null);
            case DoubleBlockTopInteractionMode.FIRST -> this.getSpriteOrDefault(data, false);
            case DoubleBlockTopInteractionMode.SECOND -> this.getSpriteOrDefault(data, true);
            case DoubleBlockTopInteractionMode.EITHER -> {
                TextureAtlasSprite sprite = this.getSprite(data, false);
                if (sprite != null) {
                    yield sprite;
                }
                sprite = this.getSprite(data, true);
                if (sprite != null) {
                    yield sprite;
                }
                yield this.originalModel.getParticleIcon();
            }
        };
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)data.get(IFramedDoubleBlockEntity.DATA_ONE), ModelData.EMPTY);
        ModelData dataRight = Objects.requireNonNullElse((ModelData)data.get(IFramedDoubleBlockEntity.DATA_TWO), ModelData.EMPTY);
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{((BakedModel)models.getA()).getRenderTypes((BlockState)this.dummyStates.getA(), rand, dataLeft), ((BakedModel)models.getB()).getRenderTypes((BlockState)this.dummyStates.getB(), rand, dataRight)});
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData tileData) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)tileData.get(IFramedDoubleBlockEntity.DATA_ONE), ModelData.EMPTY);
        ModelData dataRight = Objects.requireNonNullElse((ModelData)tileData.get(IFramedDoubleBlockEntity.DATA_TWO), ModelData.EMPTY);
        dataLeft = ((BakedModel)models.getA()).getModelData(level, pos, (BlockState)this.dummyStates.getA(), dataLeft);
        dataRight = ((BakedModel)models.getB()).getModelData(level, pos, (BlockState)this.dummyStates.getB(), dataRight);
        return tileData.derive().with(IFramedDoubleBlockEntity.DATA_ONE, (Object)dataLeft).with(IFramedDoubleBlockEntity.DATA_TWO, (Object)dataRight).build();
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData data, RenderType renderType) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        ModelData dataLeft = Objects.requireNonNullElse((ModelData)data.get(IFramedDoubleBlockEntity.DATA_ONE), ModelData.EMPTY);
        TriState aoLeft = ((BakedModel)models.getA()).useAmbientOcclusion((BlockState)this.dummyStates.getA(), dataLeft, renderType);
        if (aoLeft == TriState.TRUE) {
            return aoLeft;
        }
        ModelData dataRight = Objects.requireNonNullElse((ModelData)data.get(IFramedDoubleBlockEntity.DATA_TWO), ModelData.EMPTY);
        TriState aoRight = ((BakedModel)models.getA()).useAmbientOcclusion((BlockState)this.dummyStates.getB(), dataRight, renderType);
        if (aoRight == TriState.TRUE) {
            return aoRight;
        }
        return TriState.DEFAULT;
    }

    private Tuple<BakedModel, BakedModel> getModels() {
        if (this.models == null) {
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            this.models = new Tuple((Object)dispatcher.getBlockModel((BlockState)this.dummyStates.getA()), (Object)dispatcher.getBlockModel((BlockState)this.dummyStates.getB()));
        }
        return this.models;
    }

    private TextureAtlasSprite getSpriteOrDefault(ModelData data, boolean secondary) {
        TextureAtlasSprite sprite = this.getSprite(data, secondary);
        return sprite != null ? sprite : this.originalModel.getParticleIcon();
    }

    private TextureAtlasSprite getSprite(ModelData data, boolean secondary) {
        FramedBlockData fbData;
        ModelData innerData = (ModelData)data.get(secondary ? IFramedDoubleBlockEntity.DATA_TWO : IFramedDoubleBlockEntity.DATA_ONE);
        if (innerData != null && (fbData = (FramedBlockData)innerData.get(FramedBlockData.PROPERTY)) != null && !fbData.getCamoContent().isEmpty()) {
            BakedModel model = secondary ? (BakedModel)this.getModels().getB() : (BakedModel)this.getModels().getA();
            return model.getParticleIcon(innerData);
        }
        return null;
    }

    private static List<BakedQuad> invertTintIndizes(List<BakedQuad> quads) {
        ArrayList<BakedQuad> inverted = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            inverted.add(ModelUtils.invertTintIndex(quad));
        }
        return inverted;
    }

    private static ModelData makeDefaultData(boolean altModel) {
        FramedBlockData data = new FramedBlockData(EmptyCamoContent.EMPTY, altModel);
        return ModelData.builder().with(FramedBlockData.PROPERTY, (Object)data).build();
    }
}

