/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.apiimpl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.internal.InternalClientAPI;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.ModelFactory;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;
import xfacthd.framedblocks.api.render.debug.BlockDebugRenderer;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.modelwrapping.CopyingModelFactory;
import xfacthd.framedblocks.client.modelwrapping.ModelWrappingHandler;
import xfacthd.framedblocks.client.modelwrapping.ModelWrappingManager;
import xfacthd.framedblocks.client.render.debug.impl.ConnectionPredicateDebugRenderer;
import xfacthd.framedblocks.client.render.debug.impl.QuadWindingDebugRenderer;
import xfacthd.framedblocks.client.util.ClientTaskQueue;
import xfacthd.framedblocks.common.config.DevToolsConfig;

public final class InternalClientApiImpl
implements InternalClientAPI {
    @Override
    public void registerModelWrapper(Holder<Block> block, GeometryFactory geometryFactory, StateMerger stateMerger) {
        this.registerSpecialModelWrapper(block, ctx -> new FramedBlockModel(ctx, geometryFactory.create(ctx)), stateMerger);
    }

    @Override
    public void registerSpecialModelWrapper(Holder<Block> block, ModelFactory modelFactory, StateMerger stateMerger) {
        InternalClientApiImpl.debugStateMerger(block, stateMerger);
        ModelWrappingManager.register(block, new ModelWrappingHandler(block, modelFactory, stateMerger));
    }

    @Override
    public void registerCopyingModelWrapper(Holder<Block> block, Holder<Block> srcBlock, StateMerger stateMerger) {
        this.registerSpecialModelWrapper(block, new CopyingModelFactory(srcBlock), stateMerger);
    }

    @Override
    public BlockDebugRenderer<FramedBlockEntity> getConnectionDebugRenderer() {
        return ConnectionPredicateDebugRenderer.INSTANCE;
    }

    @Override
    public BlockDebugRenderer<FramedBlockEntity> getQuadWindingDebugRenderer() {
        return QuadWindingDebugRenderer.INSTANCE;
    }

    @Override
    public void enqueueClientTask(int delay, Runnable task) {
        ClientTaskQueue.enqueueClientTask(delay, task);
    }

    private static void debugStateMerger(Holder<Block> block, StateMerger stateMerger) {
        String key;
        if (!DevToolsConfig.VIEW.isStateMergerDebugLoggingEnabled()) {
            return;
        }
        Pattern debugFilterPattern = DevToolsConfig.VIEW.getStateMergerDebugFilter();
        if (debugFilterPattern != null && !debugFilterPattern.matcher(key = Utils.getKeyOrThrow(block).location().toString()).matches()) {
            return;
        }
        HashSet props = new HashSet(((Block)block.value()).getStateDefinition().getProperties());
        Set<Property<?>> ignoredProps = stateMerger.getHandledProperties(block);
        props.removeAll(ignoredProps);
        FramedBlocks.LOGGER.info("%-70s | %-150s | %-150s".formatted(block.value(), InternalClientApiImpl.propsToString(props), InternalClientApiImpl.propsToString(ignoredProps)));
    }

    private static String propsToString(Collection<Property<?>> properties) {
        return properties.stream().map(Property::getName).collect(Collectors.joining(", ", "[ ", " ]"));
    }
}

