/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.render.Quaternions;

public interface OutlineRenderer {
    public static final Quaternionf[] YN_DIR = OutlineRenderer.makeQuaternionArray();

    default public void draw(BlockState state, Level level, BlockPos pos, PoseStack poseStack, VertexConsumer builder) {
        this.draw(state, poseStack, builder);
    }

    public void draw(BlockState var1, PoseStack var2, VertexConsumer var3);

    default public Direction getRotationDir(BlockState state) {
        return (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
    }

    default public void rotateMatrix(PoseStack poseStack, BlockState state) {
        Direction dir = this.getRotationDir(state);
        Preconditions.checkState((boolean)dir.getAxis().isHorizontal(), (Object)"Rotation direction must be horizontal");
        poseStack.mulPose(YN_DIR[dir.get2DDataValue()]);
    }

    public static void mirrorHorizontally(PoseStack pstack, boolean rotY90) {
        pstack.mulPose(Quaternions.ZP_180);
        if (rotY90) {
            pstack.mulPose(Quaternions.YN_90);
        }
    }

    public static void drawLine(VertexConsumer builder, PoseStack poseStack, float x1, float y1, float z1, float x2, float y2, float z2) {
        float nX = x2 - x1;
        float nY = y2 - y1;
        float nZ = z2 - z1;
        float nLen = Mth.sqrt((float)(nX * nX + nY * nY + nZ * nZ));
        PoseStack.Pose pose = poseStack.last();
        builder.addVertex(pose, x1, y1, z1).setColor(0, 0, 0, 102).setNormal(pose, nX /= nLen, nY /= nLen, nZ /= nLen);
        builder.addVertex(pose, x2, y2, z2).setColor(0, 0, 0, 102).setNormal(pose, nX, nY, nZ);
    }

    public static Quaternionf[] makeQuaternionArray() {
        Quaternionf[] array = new Quaternionf[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.get2DDataValue()] = Axis.YN.rotationDegrees(dir.toYRot());
        }
        return array;
    }
}

