/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.wrapping.statemerger;

import com.mojang.logging.LogUtils;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.model.wrapping.statemerger.StateMerger;

record IgnoringStateMerger(Set<Property<?>> ignoredProps) implements StateMerger
{
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public BlockState apply(BlockState state) {
        BlockState defaultState = state.getBlock().defaultBlockState();
        for (Property<?> prop : this.ignoredProps) {
            if (!state.hasProperty(prop)) {
                LOGGER.warn("Found invalid ignored property {} for block {}!", prop, (Object)state.getBlock());
                continue;
            }
            state = (BlockState)state.setValue(prop, defaultState.getValue(prop));
        }
        return state;
    }

    @Override
    public Set<Property<?>> getHandledProperties(Holder<Block> block) {
        return this.ignoredProps;
    }
}

