/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class MessageSetWorkAreaSize
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"set_work_area_size");
    public static final CustomPacketPayload.Type<MessageSetWorkAreaSize> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSetWorkAreaSize> STREAM_CODEC = CustomPacketPayload.codec(MessageSetWorkAreaSize::encode, MessageSetWorkAreaSize::new);
    public byte workAreaSize;

    public MessageSetWorkAreaSize(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetWorkAreaSize(WorkAreaSize workAreaSize) {
        this.workAreaSize = (byte)workAreaSize.ordinal();
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() instanceof BookOfCallingItem) {
            ItemNBTUtil.getSpiritEntity(stack).ifPresent(spirit -> {
                WorkAreaSize workAreaSize = WorkAreaSize.get(this.workAreaSize);
                spirit.setWorkAreaSize(workAreaSize);
                ItemNBTUtil.updateItemNBTFromEntity(stack, spirit);
                player.inventoryMenu.broadcastChanges();
                player.displayClientMessage((Component)Component.translatable((String)"item.occultism.book_of_calling.message_set_work_area_size", (Object[])new Object[]{TextUtil.formatDemonName((MutableComponent)spirit.getName()), Component.translatable((String)workAreaSize.getDescriptionId())}), true);
            });
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeByte(this.workAreaSize);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.workAreaSize = buf.readByte();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

