/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.impl.recipes;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionWrapper;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.ConditionWrapperFactory;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.OccultismConditionContext;
import com.klikli_dev.occultism.crafting.recipe.conditionextension.RitualRecipeConditionDescriptionVisitor;
import com.klikli_dev.occultism.integration.jei.impl.JeiRecipeTypes;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class RitualRecipeCategory
implements IRecipeCategory<RecipeHolder<RitualRecipe>> {
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable checklist;
    private final Component localizedName;
    private final String pentacle;
    private final ItemStack goldenSacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get());
    private final ItemStack sacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get());
    private final int iconWidth = 16;
    private final int ritualCenterX;
    private final int ritualCenterY;
    private int recipeOutputOffsetX = 50;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 120);
        this.ritualCenterX = this.background.getWidth() / 2 - this.iconWidth / 2 - 30;
        this.ritualCenterY = this.background.getHeight() / 2 - this.iconWidth / 2 + 20;
        this.localizedName = Component.translatable((String)"occultism.jei.ritual");
        this.pentacle = I18n.get((String)"occultism.jei.pentacle", (Object[])new Object[0]);
        this.arrow = guiHelper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/jei/arrow.png"), 0, 0, 64, 46);
        this.checklist = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/gui/jei/checklist.png"), 0, 0, 64, 64).setTextureSize(64, 64).build();
    }

    protected int getStringCenteredMaxX(Font font, Component text, int x, int y) {
        int width = font.width((FormattedText)text);
        int actualX = (int)((float)x - (float)width / 2.0f);
        return actualX + width;
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, Component text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.width((FormattedText)text) / 2.0f, (float)y, 0, false);
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.width(text) / 2.0f, (float)y, 0, false);
    }

    public RecipeType<RecipeHolder<RitualRecipe>> getRecipeType() {
        return JeiRecipeTypes.RITUAL;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RitualRecipe> recipe, IFocusGroup focuses) {
        this.recipeOutputOffsetX = 75;
        builder.addSlot(RecipeIngredientRole.INPUT, this.ritualCenterX, this.ritualCenterY - 5).addIngredients(((RitualRecipe)recipe.value()).getActivationItem());
        builder.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX, this.ritualCenterY).addItemStack(this.goldenSacrificialBowl);
        int sacrificialCircleRadius = 30;
        int sacricialBowlPaddingVertical = 20;
        int sacricialBowlPaddingHorizontal = 15;
        List sacrificialBowlPosition = Stream.of(new Vec3i(this.ritualCenterX, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0)).collect(Collectors.toList());
        for (int i = 0; i < ((RitualRecipe)recipe.value()).getIngredients().size(); ++i) {
            Vec3i pos = (Vec3i)sacrificialBowlPosition.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, pos.getX(), pos.getY() - 5).addIngredients((Ingredient)((RitualRecipe)recipe.value()).getIngredients().get(i));
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, pos.getX(), pos.getY()).addItemStack(this.sacrificialBowl);
        }
        RegistryAccess access = Minecraft.getInstance().level.registryAccess();
        if (((RitualRecipe)recipe.value()).getResultItem((HolderLookup.Provider)access).getItem() != OccultismItems.JEI_DUMMY_NONE.get()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5).addItemStack(((RitualRecipe)recipe.value()).getResultItem((HolderLookup.Provider)access));
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5).addItemStack(((RitualRecipe)recipe.value()).getRitualDummy());
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY).addItemStack(this.goldenSacrificialBowl);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 0, 0).addItemStack(((RitualRecipe)recipe.value()).getRitualDummy());
        if (((RitualRecipe)recipe.value()).requiresItemUse()) {
            int infotextY = 0;
            Objects.requireNonNull(Minecraft.getInstance().font);
            int lineHeight = 9;
            Multiblock pentacle = ModonomiconAPI.get().getMultiblock(((RitualRecipe)recipe.value()).getPentacleId());
            if (pentacle != null) {
                List pentacleName = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)Util.makeDescriptionId((String)"multiblock", (ResourceLocation)pentacle.getId())), 150);
                for (FormattedCharSequence line : pentacleName) {
                    infotextY += lineHeight;
                }
            }
            if (((RitualRecipe)recipe.value()).requiresSacrifice()) {
                infotextY += lineHeight;
            }
            int itemToUseY = infotextY - 5;
            int infoTextX = 94;
            int itemToUseX = this.getStringCenteredMaxX(Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.item_to_use"), infoTextX, infotextY);
            builder.addSlot(RecipeIngredientRole.CATALYST, itemToUseX, itemToUseY).addIngredients(((RitualRecipe)recipe.value()).getItemToUse());
        }
    }

    public void draw(RecipeHolder<RitualRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(guiGraphics, this.ritualCenterX + this.recipeOutputOffsetX - 20, this.ritualCenterY);
        RenderSystem.disableBlend();
        int infotextY = 0;
        int infoTextX = 94;
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        Multiblock pentacle = ModonomiconAPI.get().getMultiblock(((RitualRecipe)recipe.value()).getPentacleId());
        if (pentacle != null) {
            List pentacleName = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)Util.makeDescriptionId((String)"multiblock", (ResourceLocation)pentacle.getId())), 150);
            for (FormattedCharSequence line : pentacleName) {
                this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, line, infoTextX, infotextY);
                infotextY += lineHeight;
            }
        } else {
            this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.error.pentacle_not_loaded"), infoTextX, 0);
        }
        if (((RitualRecipe)recipe.value()).requiresSacrifice()) {
            this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.sacrifice", (Object[])new Object[]{Component.translatable((String)((RitualRecipe)recipe.value()).getEntityToSacrificeDisplayName())}), infoTextX, infotextY);
            infotextY += lineHeight;
        }
        if (((RitualRecipe)recipe.value()).requiresItemUse()) {
            this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.item_to_use"), infoTextX, infotextY);
            infotextY += lineHeight;
        }
        if (((RitualRecipe)recipe.value()).getEntityToSummon() != null) {
            this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.summon", (Object[])new Object[]{Component.translatable((String)((RitualRecipe)recipe.value()).getEntityToSummon().getDescriptionId())}), infoTextX, infotextY);
            infotextY += lineHeight;
        }
        if (((RitualRecipe)recipe.value()).getSpiritJobType() != null) {
            this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)Component.translatable((String)"jei.occultism.job", (Object[])new Object[]{Component.translatable((String)("job." + ((RitualRecipe)recipe.value()).getSpiritJobType().toString().replace(":", ".")))}), infoTextX, infotextY);
        }
        if (((RitualRecipe)recipe.value()).getCondition() != null) {
            RitualRecipeConditionDescriptionVisitor visitor = new RitualRecipeConditionDescriptionVisitor();
            ConditionWrapper<?> condition = ConditionWrapperFactory.wrap(((RitualRecipe)recipe.value()).getCondition());
            if (condition != null) {
                this.drawStringCentered(guiGraphics, Minecraft.getInstance().font, (Component)condition.accept(visitor, OccultismConditionContext.EMPTY), infoTextX, infotextY);
            }
        }
    }
}

