/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.level.cave;

import com.klikli_dev.occultism.common.block.otherworld.OtherflowerNaturalBlock;
import com.klikli_dev.occultism.common.block.otherworld.OtherstoneNaturalBlock;
import com.klikli_dev.occultism.common.level.cave.CaveDecorator;
import com.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class UndergroundGroveDecorator
extends CaveDecorator {
    public static final ResourceLocation OTHERWORLD_TREE_NATURAL = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"otherworld_tree_natural");

    public UndergroundGroveDecorator() {
        super(Blocks.GRASS_BLOCK.defaultBlockState(), null, ((OtherstoneNaturalBlock)OccultismBlocks.OTHERSTONE_NATURAL.get()).defaultBlockState());
    }

    @Override
    public void finalFloorPass(WorldGenLevel seedReader, ChunkGenerator generator, RandomSource rand, BlockPos pos, MultiChunkFeatureConfig config) {
        if (seedReader.getBlockState(pos).getBlock() == Blocks.GRASS_BLOCK) {
            if (rand.nextFloat() < config.grassChance) {
                seedReader.setBlock(pos.above(), Blocks.SHORT_GRASS.defaultBlockState(), 2);
            } else if (rand.nextFloat() < config.flowerChance) {
                seedReader.setBlock(pos.above(), ((OtherflowerNaturalBlock)OccultismBlocks.OTHERFLOWER_NATURAL.get()).defaultBlockState(), 2);
            }
        }
        if (rand.nextFloat() < config.treeChance) {
            ((PlacedFeature)config.otherworldTreeFeature.value()).place(seedReader, generator, rand, pos.above());
        }
    }

    @Override
    public void finalCeilingPass(WorldGenLevel seedReader, ChunkGenerator generator, RandomSource rand, BlockPos pos, MultiChunkFeatureConfig config) {
        if (rand.nextFloat() < config.ceilingLightChance) {
            seedReader.setBlock(pos, Blocks.GLOWSTONE.defaultBlockState(), 2);
        }
        super.finalCeilingPass(seedReader, generator, rand, pos, config);
    }

    @Override
    public void finalWallPass(WorldGenLevel seedReader, ChunkGenerator generator, RandomSource rand, BlockPos pos, MultiChunkFeatureConfig config) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.relative(facing);
            BlockPos up = offset.above();
            if (!this.isCeiling(seedReader, up, seedReader.getBlockState(up)) || !(rand.nextFloat() < config.vineChance)) continue;
            BlockState stateAt = seedReader.getBlockState(offset);
            boolean spawnedVine = false;
            while (stateAt.isAir() && offset.getY() > 0) {
                seedReader.setBlock(offset, (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)facing.getOpposite()), (Comparable)Boolean.valueOf(true)), 2);
                offset = offset.below();
                stateAt = seedReader.getBlockState(offset);
                spawnedVine = true;
            }
            if (!spawnedVine) continue;
            return;
        }
    }
}

