/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool.ritual_satchel;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.common.container.satchel.RitualSatchelT1Container;
import com.klikli_dev.occultism.common.item.tool.ritual_satchel.PentacleData;
import com.klikli_dev.occultism.common.item.tool.ritual_satchel.RitualSatchelItem;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;

public class SingleBlockRitualSatchelItem
extends RitualSatchelItem {
    public SingleBlockRitualSatchelItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected Function4<Integer, Inventory, Container, Integer, AbstractContainerMenu> containerFactory() {
        return RitualSatchelT1Container::new;
    }

    @Override
    protected InteractionResult useOnServerSide(UseOnContext context) {
        PentacleData targetPentacle = this.targetPentacles().get(context.getPlayer().getUUID());
        if (targetPentacle == null || targetPentacle.timeWhenAdded() < context.getLevel().getGameTime() - 5L) {
            return InteractionResult.FAIL;
        }
        if (!targetPentacle.target().equals((Object)context.getClickedPos())) {
            return InteractionResult.FAIL;
        }
        Multiblock multiblock = ModonomiconAPI.get().getMultiblock(targetPentacle.multiblock());
        Pair simulation = multiblock.simulate(context.getLevel(), targetPentacle.anchor(), targetPentacle.facing(), false, false);
        Optional<Multiblock.SimulateResult> targetMatcher = ((Collection)simulation.getSecond()).stream().filter(p -> p.getWorldPosition().equals((Object)context.getClickedPos())).findFirst();
        if (targetMatcher.isEmpty()) {
            return InteractionResult.FAIL;
        }
        return switch (this.tryPlaceBlockForMatcher(context, targetMatcher.get())) {
            case RitualSatchelItem.PlacementResult.SUCCESS -> InteractionResult.SUCCESS;
            case RitualSatchelItem.PlacementResult.ERROR_NO_MATCHING_BLOCK_FOUND -> {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.occultism.ritual_satchel.no_valid_item_in_satchel").withStyle(ChatFormatting.YELLOW), true);
                yield InteractionResult.FAIL;
            }
            case RitualSatchelItem.PlacementResult.ERROR_BLOCK_ABOVE_NOT_AIR -> {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.occultism.ritual_satchel.block_above_not_air").withStyle(ChatFormatting.YELLOW), true);
                yield InteractionResult.FAIL;
            }
            case RitualSatchelItem.PlacementResult.ERROR_BLOCK_AT_POSITION_NOT_AIR -> {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.occultism.ritual_satchel.block_at_position_not_air").withStyle(ChatFormatting.YELLOW), true);
                yield InteractionResult.FAIL;
            }
            case RitualSatchelItem.PlacementResult.ERROR_INVALID_MATCHER -> {
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.occultism.ritual_satchel.invalid_matcher").withStyle(ChatFormatting.YELLOW), true);
                yield InteractionResult.FAIL;
            }
            default -> InteractionResult.FAIL;
        };
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack))}));
    }
}

