/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.common.entity.ai.goal.DepositItemsGoal;
import com.klikli_dev.occultism.common.entity.ai.goal.FallbackDepositToControllerGoal;
import com.klikli_dev.occultism.common.entity.ai.goal.ManageMachineGoal;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.misc.DepositOrder;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ManageMachineJob
extends SpiritJob {
    protected DepositItemsGoal depositItemsGoal;
    protected ManageMachineGoal manageMachineGoal;
    protected FallbackDepositToControllerGoal fallbackDepositToControllerGoal;
    protected OpenDoorGoal openDoorGoal;
    protected GlobalBlockPos storageControllerPosition;
    protected MachineReference managedMachine;
    protected DepositOrder currentDepositOrder;
    protected Queue<DepositOrder> depositOrderQueue = new ArrayDeque<DepositOrder>();
    protected IStorageController storageController;
    protected BlockEntity managedMachineBlockEntity;
    protected BlockEntity extractBlockEntity;

    public ManageMachineJob(SpiritEntity entity) {
        super(entity);
    }

    public DepositOrder getCurrentDepositOrder() {
        return this.currentDepositOrder;
    }

    public void setCurrentDepositOrder(DepositOrder order) {
        this.currentDepositOrder = order;
    }

    public MachineReference getManagedMachine() {
        return this.managedMachine;
    }

    public void setManagedMachine(MachineReference managedMachine) {
        if (this.managedMachine != null) {
            this.unregisterFromStorageController();
        }
        this.managedMachine = managedMachine;
        this.managedMachineBlockEntity = null;
        this.extractBlockEntity = null;
        this.clearAllOrders();
        this.registerWithStorageController();
    }

    public GlobalBlockPos getStorageControllerPosition() {
        return this.storageControllerPosition;
    }

    public void setStorageControllerPosition(GlobalBlockPos storageControllerPosition) {
        if (this.storageControllerPosition != null) {
            this.unregisterFromStorageController();
        }
        this.storageControllerPosition = storageControllerPosition;
        this.storageController = null;
        this.clearAllOrders();
        this.registerWithStorageController();
    }

    public IStorageController getStorageController() {
        if (this.storageControllerPosition == null) {
            return null;
        }
        if (this.storageController == null) {
            this.storageController = (IStorageController)BlockEntityUtil.get(this.entity.level(), this.storageControllerPosition);
        }
        if (this.storageController == null) {
            this.storageControllerPosition = null;
        }
        return this.storageController;
    }

    public BlockEntity getManagedMachineBlockEntity() {
        if (this.managedMachine == null) {
            return null;
        }
        if (this.managedMachineBlockEntity == null) {
            this.managedMachineBlockEntity = BlockEntityUtil.get(this.entity.level(), this.managedMachine.insertGlobalPos);
        }
        return this.managedMachineBlockEntity;
    }

    public BlockEntity getExtractBlockEntity() {
        if (this.managedMachine == null) {
            return null;
        }
        if (this.extractBlockEntity == null) {
            this.extractBlockEntity = BlockEntityUtil.get(this.entity.level(), this.managedMachine.extractGlobalPos);
        }
        return this.extractBlockEntity;
    }

    @Override
    public void onInit() {
        this.entity.getNavigation().getNodeEvaluator().setCanPassDoors(true);
        ((GroundPathNavigation)this.entity.getNavigation()).setCanOpenDoors(true);
        this.manageMachineGoal = new ManageMachineGoal(this.entity, this);
        this.entity.goalSelector.addGoal(3, (Goal)this.manageMachineGoal);
        this.fallbackDepositToControllerGoal = new FallbackDepositToControllerGoal(this.entity, this);
        this.entity.goalSelector.addGoal(4, (Goal)this.fallbackDepositToControllerGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.goalSelector.addGoal(4, (Goal)this.depositItemsGoal);
        this.openDoorGoal = new OpenDoorGoal((Mob)this.entity, true);
        this.entity.goalSelector.addGoal(5, (Goal)this.openDoorGoal);
        this.registerWithStorageController();
    }

    @Override
    public void cleanup() {
        this.entity.getNavigation().getNodeEvaluator().setCanPassDoors(false);
        ((GroundPathNavigation)this.entity.getNavigation()).setCanOpenDoors(false);
        this.entity.goalSelector.removeGoal((Goal)this.depositItemsGoal);
        this.entity.goalSelector.removeGoal((Goal)this.manageMachineGoal);
        this.entity.goalSelector.removeGoal((Goal)this.openDoorGoal);
        this.entity.goalSelector.removeGoal((Goal)this.fallbackDepositToControllerGoal);
        this.unregisterFromStorageController();
    }

    @Override
    public void update() {
        if (this.storageControllerPosition != null && this.managedMachine != null && this.getCurrentDepositOrder() == null && !this.depositOrderQueue.isEmpty()) {
            this.setCurrentDepositOrder(this.depositOrderQueue.poll());
        }
        if (this.currentDepositOrder != null && this.currentDepositOrder.comparator == null) {
            this.setCurrentDepositOrder(null);
        }
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.storageControllerPosition != null) {
            compound.put("storageControllerPosition", (Tag)this.storageControllerPosition.serializeNBT(provider));
        }
        if (this.managedMachine != null) {
            compound.put("managedMachine", (Tag)this.managedMachine.serializeNBT(provider));
        }
        if (this.getCurrentDepositOrder() != null) {
            compound.put("currentDepositOrder", (Tag)this.getCurrentDepositOrder().writeToNBT(new CompoundTag(), provider));
        }
        ListTag nbtOrderList = new ListTag();
        for (DepositOrder depositOrder : this.depositOrderQueue) {
            nbtOrderList.add((Object)depositOrder.writeToNBT(new CompoundTag(), provider));
        }
        compound.put("depositOrders", (Tag)nbtOrderList);
        return super.writeJobToNBT(compound, provider);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("storageControllerPosition")) {
            this.storageControllerPosition = GlobalBlockPos.from(provider, compound.getCompound("storageControllerPosition"));
        }
        if (compound.contains("managedMachine")) {
            this.managedMachine = (MachineReference)((Pair)MachineReference.CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compound.get("managedMachine")).getOrThrow()).getFirst();
        }
        if (compound.contains("currentDepositOrder")) {
            this.setCurrentDepositOrder(DepositOrder.from(compound.getCompound("currentDepositOrder"), provider));
        }
        this.depositOrderQueue = new ArrayDeque<DepositOrder>();
        if (compound.contains("depositOrders")) {
            ListTag nbtOrderList = compound.getList("depositOrders", 10);
            for (int i = 0; i < nbtOrderList.size(); ++i) {
                DepositOrder depositOrder = DepositOrder.from(nbtOrderList.getCompound(i), provider);
                this.depositOrderQueue.add(depositOrder);
            }
        }
        super.readJobFromNBT(compound, provider);
    }

    public void addDepsitOrder(DepositOrder order) {
        this.depositOrderQueue.add(order);
    }

    public void clearAllOrders() {
        this.currentDepositOrder = null;
        this.depositOrderQueue.clear();
    }

    protected void registerWithStorageController() {
        IStorageController storageController = this.getStorageController();
        if (storageController != null && this.managedMachine != null) {
            storageController.addDepositOrderSpirit(this.managedMachine.insertGlobalPos, this.entity.getUUID());
            storageController.linkMachine(this.managedMachine);
            BlockEntityUtil.updateTile(this.entity.level(), this.getStorageControllerPosition().getPos());
        }
    }

    protected void unregisterFromStorageController() {
        IStorageController storageController;
        if (this.storageControllerPosition != null && this.managedMachine != null && (storageController = this.getStorageController()) != null) {
            storageController.removeDepositOrderSpirit(this.managedMachine.insertGlobalPos);
        }
    }
}

