/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.registry.OccultismItems;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OfferFlowerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.DefendVillageTargetGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class IesniumGolemEntity
extends IronGolem {
    public IesniumGolemEntity(EntityType<? extends IronGolem> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.goalSelector.addGoal(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(5, (Goal)new OfferFlowerGoal((IronGolem)this));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new DefendVillageTargetGoal((IronGolem)this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((IesniumGolemEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, p_28879_ -> p_28879_ instanceof Enemy));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return IronGolem.createAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 100.0).add(Attributes.ATTACK_SPEED, 5.0).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    public boolean canAttackType(EntityType<?> type) {
        return type != EntityType.PLAYER;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            this.teleportTo(this.level().getSharedSpawnPos().getX(), this.level().getSharedSpawnPos().getY(), this.level().getSharedSpawnPos().getZ());
            while (!(this.level().getBlockState(this.getOnPos()).getBlock().isPossibleToRespawnInThis(this.level().getBlockState(this.getOnPos())) && this.level().getBlockState(this.getOnPos(1.0f)).getBlock().isPossibleToRespawnInThis(this.level().getBlockState(this.getOnPos(1.0f))) && this.level().getBlockState(this.getOnPos(2.0f)).getBlock().isPossibleToRespawnInThis(this.level().getBlockState(this.getOnPos(2.0f))) && this.level().getBlockState(this.getOnPos(3.0f)).getBlock().isPossibleToRespawnInThis(this.level().getBlockState(this.getOnPos(3.0f))))) {
                this.teleportRelative(0.0, 1.0, 0.0);
            }
        }
        if (source.getEntity() == null || !source.getEntity().isCrouching()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        ItemStack shard = new ItemStack((ItemLike)OccultismItems.FRAGILE_SOUL_GEM_ITEM.get());
        float health = this.getHealth();
        this.setHealth(this.getMaxHealth());
        this.resetFallDistance();
        this.removeAllEffects();
        this.remove(Entity.RemovalReason.DISCARDED);
        CompoundTag entityData = new CompoundTag();
        String id = this.getEncodeId();
        if (id != null) {
            entityData.putString("id", id);
        }
        entityData = this.saveWithoutId(entityData);
        shard.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
        this.setHealth(health);
        ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), shard);
        entityitem.setPickUpDelay(5);
        entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
        this.level().addFreshEntity((Entity)entityitem);
        return super.hurt(source, amount);
    }
}

