/*
 * Decompiled with CFR 0.152.
 */
package stdlib;

import java.util.function.Function;

public abstract class Result<T, E> {
    public static <T, E extends Exception> T unwrap(Class<T> typeOfT, Class<E> typeOfE, Result<T, E> self) throws E {
        return switch (self.getDiscriminant().ordinal()) {
            case 0 -> {
                Object result;
                yield result = ((Ok)self).value;
            }
            case 1 -> {
                Exception error = (Exception)((Error)self).value;
                throw error;
            }
            default -> throw new AssertionError((Object)"Missing case");
        };
    }

    public <R> Result<R, E> then(Class<R> typeOfR, Function<T, Result<R, E>> fn) {
        return switch (this.getDiscriminant().ordinal()) {
            case 0 -> {
                Object result = ((Ok)this).value;
                yield fn.apply(result);
            }
            case 1 -> {
                Object error = ((Error)this).value;
                yield new Error<R, E>(error);
            }
            default -> throw new AssertionError((Object)"Missing case");
        };
    }

    public <X> Result<T, X> handle(Class<X> typeOfX, Function<E, Result<T, X>> handler) {
        return switch (this.getDiscriminant().ordinal()) {
            case 0 -> {
                Object result = ((Ok)this).value;
                yield new Ok(result);
            }
            case 1 -> {
                Object error = ((Error)this).value;
                yield handler.apply(error);
            }
            default -> throw new AssertionError((Object)"Missing case");
        };
    }

    public T expect() {
        return switch (this.getDiscriminant().ordinal()) {
            case 0 -> {
                Object result;
                yield result = ((Ok)this).value;
            }
            case 1 -> {
                Object error = ((Error)this).value;
                throw new AssertionError((Object)"expect() called on an error value");
            }
            default -> throw new AssertionError((Object)"Missing case");
        };
    }

    public T orElse(T other) {
        return switch (this.getDiscriminant().ordinal()) {
            case 0 -> {
                Object result;
                yield result = ((Ok)this).value;
            }
            case 1 -> {
                Object error = ((Error)this).value;
                yield other;
            }
            default -> throw new AssertionError((Object)"Missing case");
        };
    }

    public T orElse(Function<E, T> other) {
        return switch (this.getDiscriminant().ordinal()) {
            case 0 -> {
                Object result;
                yield result = ((Ok)this).value;
            }
            case 1 -> {
                Object error = ((Error)this).value;
                yield other.apply(error);
            }
            default -> throw new AssertionError((Object)"Missing case");
        };
    }

    public abstract Discriminant getDiscriminant();

    public static enum Discriminant {
        Ok,
        Error;

    }

    public static class Ok<T, E>
    extends Result<T, E> {
        public final T value;

        public Ok(T value) {
            this.value = value;
        }

        @Override
        public Discriminant getDiscriminant() {
            return Discriminant.Ok;
        }
    }

    public static class Error<T, E>
    extends Result<T, E> {
        public final E value;

        public Error(E value) {
            this.value = value;
        }

        @Override
        public Discriminant getDiscriminant() {
            return Discriminant.Error;
        }
    }
}

