/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.attribute.ItemAttributeModifierBase;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.entity.ExpandEntity;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker.natives.entity.type.player.ExpandPlayer;
import com.blamejared.crafttweaker.natives.world.ExpandBlockGetter;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface IEventHelper {
    public static final Map<RecipeType<?>, List<Pair<IIngredient, Integer>>> BURN_TIMES = new HashMap();
    public static final Set<Player> BLOCK_INFO_PLAYERS = new HashSet<Player>();
    public static final Set<Player> ENTITY_INFO_PLAYERS = new HashSet<Player>();
    public static final Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> ATTRIBUTE_MODIFIERS = new HashMap<IIngredient, List<Consumer<ItemAttributeModifierBase>>>();

    default public void setBurnTime(IIngredient ingredient, int burnTime, RecipeType<?> type) {
        this.getBurnTimes().computeIfAbsent(type, recipeType -> new ArrayList()).add(Pair.of((Object)ingredient, (Object)burnTime));
    }

    public int getBurnTime(IItemStack var1);

    default public Map<RecipeType<?>, List<Pair<IIngredient, Integer>>> getBurnTimes() {
        return BURN_TIMES;
    }

    default public Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> getAttributeModifiers() {
        return ATTRIBUTE_MODIFIERS;
    }

    default public boolean onBlockInteract(Player player, InteractionHand hand, BlockHitResult hitResult) {
        Level world = player.level();
        BlockPos pos = hitResult.getBlockPos();
        if (BLOCK_INFO_PLAYERS.contains(player)) {
            if (!world.isClientSide() && hand == InteractionHand.MAIN_HAND) {
                IData tileData;
                BlockState state = world.getBlockState(pos);
                IEventHelper.sendAndLog(player, Component.translatable((String)"crafttweaker.command.info.block.name", (Object[])new Object[]{BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString()}));
                String blockCS = ExpandBlock.getCommandString(state.getBlock());
                String blockStateCS = ExpandBlockState.getCommandString(state);
                CommandUtilities.sendCopying(player.createCommandSourceStack(), Component.translatable((String)"crafttweaker.command.misc.block").append(": ").append((Component)Component.literal((String)blockCS).withStyle(ChatFormatting.GREEN)), blockCS);
                CommandUtilities.sendCopying(player.createCommandSourceStack(), Component.translatable((String)"crafttweaker.command.misc.blockstate").append(": ").append((Component)Component.literal((String)blockStateCS).withStyle(ChatFormatting.GREEN)), blockStateCS);
                if (!state.getProperties().isEmpty()) {
                    IEventHelper.sendAndLog(player, Component.translatable((String)"crafttweaker.command.info.block.properties"));
                    state.getProperties().forEach(property -> IEventHelper.sendAndLog(player, Component.literal((String)("    " + property.getName())).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)state.getValue(property).toString()).withStyle(ChatFormatting.AQUA))));
                }
                if (!(tileData = ExpandBlockGetter.getBlockEntityData((BlockGetter)world, pos)).isEmpty()) {
                    IEventHelper.sendAndLog(player, Component.translatable((String)"crafttweaker.command.info.block.entity.data", (Object[])new Object[]{tileData.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    default public boolean onEntityInteract(Player player, InteractionHand hand, Entity target) {
        Level world = player.level();
        if (ENTITY_INFO_PLAYERS.contains(player)) {
            if (!world.isClientSide() && hand == InteractionHand.MAIN_HAND) {
                IEventHelper.sendAndLog(player, Component.translatable((String)"crafttweaker.command.info.entity.name", (Object[])new Object[]{ExpandEntity.getName(target)}));
                IEventHelper.sendAndLog(player, Component.translatable((String)"crafttweaker.command.info.entity.type.bracket", (Object[])new Object[]{ExpandEntityType.getCommandString((EntityType<Entity>)((EntityType)GenericUtil.uncheck(target.getType())))}));
                MapData data = ExpandEntity.getData(target);
                if (!data.isEmpty()) {
                    IEventHelper.sendAndLog(player, Component.translatable((String)"crafttweaker.command.info.entity.data", (Object[])new Object[]{data.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    private static void sendAndLog(Player player, MutableComponent component) {
        ExpandPlayer.sendMessage(player, (Component)component);
        CommonLoggers.api().info(component.getString());
    }
}

