/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.helper.inventory;

import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class IItemHandlerWrapper
implements IInventoryWrapper {
    private final IItemHandler handler;

    public IItemHandlerWrapper(IItemHandler handler) {
        this.handler = handler;
    }

    @Override
    public int getContainerSize() {
        return this.handler.getSlots();
    }

    @Override
    @Nonnull
    public ItemStack getItem(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Override
    public boolean canFitInSlot(int slot, ItemStack stack) {
        ItemStack item = this.getItem(slot);
        if (item.isEmpty()) {
            return true;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack)) {
            int maxStackSize = Math.min(this.handler.getSlotLimit(slot), item.getMaxStackSize());
            return item.getCount() + stack.getCount() < maxStackSize;
        }
        return false;
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot >= 0 && slot < this.handler.getSlots()) {
            return this.handler.insertItem(slot, stack, simulate);
        }
        return stack;
    }
}

