/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.CompoundFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SingleFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.TagFluidIngredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="neoforge/api/ingredient/FluidIngredient")
@NativeTypeRegistration(value=FluidIngredient.class, zenCodeName="crafttweaker.neoforge.api.item.FluidIngredient")
public class ExpandFluidIngredient {
    @ZenCodeType.StaticExpansionMethod
    public static FluidIngredient of() {
        return FluidIngredient.of();
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidIngredient of(IFluidStack ... fluids) {
        return FluidIngredient.of((FluidStack[])((FluidStack[])Arrays.stream(fluids).map(IFluidStack::getInternal).toArray(FluidStack[]::new)));
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidIngredient of(Fluid ... fluids) {
        return FluidIngredient.of((Fluid[])fluids);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidIngredient single(IFluidStack stack) {
        return FluidIngredient.single((FluidStack)((FluidStack)stack.getInternal()));
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidIngredient single(Fluid fluid) {
        return FluidIngredient.single((Fluid)fluid);
    }

    @ZenCodeType.StaticExpansionMethod
    public static FluidIngredient tag(KnownTag<Fluid> tag) {
        return FluidIngredient.tag(tag.getTagKey());
    }

    @ZenCodeType.Getter(value="hasNoFluids")
    public static boolean hasNoFluids(FluidIngredient internal) {
        return internal.hasNoFluids();
    }

    @ZenCodeType.Getter(value="empty")
    public static boolean isEmpty(FluidIngredient internal) {
        return internal.isEmpty();
    }

    @ZenCodeType.Getter(value="simple")
    public static boolean isSimple(FluidIngredient internal) {
        return internal.isSimple();
    }

    @ZenCodeType.Method
    public static boolean test(FluidIngredient internal, FluidStack fluidStack) {
        return internal.test(fluidStack);
    }

    @ZenCodeType.Getter(value="stacks")
    public static FluidStack[] getStacks(FluidIngredient internal) {
        return internal.getStacks();
    }

    @ZenCodeType.Caster(implicit=true)
    public static CTFluidIngredient asCTFluidIngredient(FluidIngredient internal) {
        return ExpandFluidIngredient.asCTFluidIngredient(internal, 1);
    }

    @ZenCodeType.Method
    public static CTFluidIngredient asCTFluidIngredient(FluidIngredient internal, int amount) {
        FluidIngredient fluidIngredient2 = internal;
        Objects.requireNonNull(fluidIngredient2);
        FluidIngredient fluidIngredient3 = fluidIngredient2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TagFluidIngredient.class, SingleFluidIngredient.class, CompoundFluidIngredient.class}, (Object)fluidIngredient3, n)) {
            case 0: {
                TagFluidIngredient tfi = (TagFluidIngredient)fluidIngredient3;
                KnownTag tag = (KnownTag)CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.FLUID).tag(tfi.tag());
                return new CTFluidIngredient.FluidTagWithAmountIngredient(tag.withAmount(amount));
            }
            case 1: {
                SingleFluidIngredient sfi = (SingleFluidIngredient)fluidIngredient3;
                return new CTFluidIngredient.FluidStackIngredient(IFluidStack.of((Fluid)sfi.fluid().value(), amount));
            }
            case 2: {
                CompoundFluidIngredient cfi = (CompoundFluidIngredient)fluidIngredient3;
                return cfi.children().stream().map(fluidIngredient -> ExpandFluidIngredient.asCTFluidIngredient(fluidIngredient, amount)).filter(ctFluidIngredient -> ctFluidIngredient != CTFluidIngredient.EMPTY.get()).reduce(CTFluidIngredient::asCompound).orElseGet(CTFluidIngredient.EMPTY);
            }
        }
        if (internal.hasNoFluids()) {
            return CTFluidIngredient.EMPTY.get();
        }
        return Arrays.stream(internal.getStacks()).map(fluidStack -> IFluidStack.of(fluidStack.copyWithAmount(amount)).asFluidIngredient()).reduce(CTFluidIngredient::asCompound).orElseGet(CTFluidIngredient.EMPTY);
    }
}

