/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.block;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.block.ActionSetBlockProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.mixin.common.access.block.AccessBlockStateBase;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/BlockState")
@NativeTypeRegistration(value=BlockState.class, zenCodeName="crafttweaker.api.block.BlockState")
public class ExpandBlockState {
    private static final BiPredicate<BlockState, BlockState> PROPERTY_EQUALS = (ts, os) -> ts.getValues().entrySet().stream().allMatch(entry -> ((Comparable)entry.getValue()).equals(os.getValue((Property)entry.getKey())));

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="soundType")
    public static SoundType getSoundType(BlockState internal) {
        return internal.getSoundType();
    }

    @ZenCodeType.Method
    public static BlockState rotate(BlockState internal, Rotation rotation) {
        return internal.rotate(rotation);
    }

    @ZenCodeType.Getter(value="block")
    @ZenCodeType.Caster(implicit=true)
    public static Block getBlock(BlockState internal) {
        return internal.getBlock();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="lightEmission")
    public static int getLightEmission(BlockState internal) {
        return internal.getLightEmission();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSignalSource")
    public static boolean isSignalSource(BlockState internal) {
        return internal.isSignalSource();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canOcclude")
    public static boolean canOcclude(BlockState internal) {
        return internal.canOcclude();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isRandomlyTicking")
    public static boolean isRandomlyTicking(BlockState internal) {
        return internal.isRandomlyTicking();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hasBlockEntity")
    public static boolean hasBlockEntity(BlockState internal) {
        return internal.hasBlockEntity();
    }

    @ZenCodeType.Method
    public static BlockState withProperty(BlockState internal, String name, String value) {
        Property property = internal.getBlock().getStateDefinition().getProperty(name);
        if (property == null) {
            CommonLoggers.api().warn("Invalid property name '" + name + "'");
        } else {
            Optional propValue = property.getValue(value);
            if (propValue.isPresent()) {
                return (BlockState)internal.setValue(property, (Comparable)propValue.get());
            }
            CommonLoggers.api().warn("Invalid property value for name '" + name + "'");
        }
        return internal;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="propertyNames")
    public static List<String> getPropertyNames(BlockState internal) {
        ArrayList<String> props = new ArrayList<String>();
        for (Property prop : internal.getProperties()) {
            props.add(prop.getName());
        }
        return ImmutableList.copyOf(props);
    }

    @ZenCodeType.Method
    public static String getPropertyValue(BlockState internal, String name) {
        Property prop = internal.getBlock().getStateDefinition().getProperty(name);
        if (prop != null) {
            return internal.getValue(prop).toString();
        }
        CommonLoggers.api().warn("Invalid property name");
        return "";
    }

    @ZenCodeType.Method
    public static List<String> getAllowedValuesForProperty(BlockState internal, String name) {
        Property prop = internal.getBlock().getStateDefinition().getProperty(name);
        if (prop != null) {
            ArrayList<String> values = new ArrayList<String>();
            prop.getPossibleValues().forEach(v -> values.add(v.toString()));
            return values;
        }
        CommonLoggers.api().warn("Invalid property name");
        return ImmutableList.of();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="properties")
    public static Map<String, String> getProperties(BlockState internal) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property key : internal.getProperties()) {
            props.put(key.getName(), internal.getValue(key).toString());
        }
        return ImmutableMap.copyOf(props);
    }

    @ZenCodeType.Method
    public static boolean hasProperty(BlockState internal, String name) {
        Property prop = internal.getBlock().getStateDefinition().getProperty(name);
        return prop != null;
    }

    @ZenCodeType.Method
    public static String asString(BlockState internal) {
        return internal.toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="destroySpeed")
    public static float getDestroySpeed(BlockState internal) {
        return ((AccessBlockStateBase)internal).crafttweaker$getDestroySpeed();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="destroySpeed")
    public static void setDestroySpeed(BlockState internal, float destroySpeed) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Destroy Speed", Float.valueOf(destroySpeed), Float.valueOf(((AccessBlockStateBase)internal).crafttweaker$getDestroySpeed()), value -> ((AccessBlockStateBase)internal).crafttweaker$setDestroySpeed(value.floatValue())));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    @ZenCodeType.Caster
    public static String getCommandString(BlockState internal) {
        StringBuilder builder = new StringBuilder("<blockstate:");
        builder.append(ExpandBlock.getRegistryName(ExpandBlockState.getBlock(internal)));
        if (!ExpandBlockState.getProperties(internal).isEmpty()) {
            builder.append(":");
            builder.append(ExpandBlockState.getProperties(internal).entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining(",")));
        }
        builder.append(">");
        return builder.toString();
    }

    @ZenCodeType.Caster(implicit=true)
    public static CTBlockIngredient asBlockIngredient(BlockState internal) {
        return new CTBlockIngredient.BlockStateIngredient(internal);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static CTBlockIngredient asList(BlockState internal, CTBlockIngredient other) {
        ArrayList<CTBlockIngredient> elements = new ArrayList<CTBlockIngredient>();
        elements.add(ExpandBlockState.asBlockIngredient(internal));
        elements.add(other);
        return new CTBlockIngredient.CompoundBlockIngredient(elements);
    }

    @ZenCodeType.Method
    public static boolean matches(BlockState internal, BlockState other) {
        return internal.is(other.getBlock()) && internal.getProperties().stream().allMatch(property -> internal.getValue(property).equals(other.getValue(property)));
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public static boolean equals(BlockState internal, BlockState other) {
        return internal.is(other.getBlock()) && PROPERTY_EQUALS.test(internal, other) && PROPERTY_EQUALS.test(other, internal);
    }
}

