/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script.scriptrun;

import com.blamejared.crafttweaker.impl.script.scriptrun.GameTestScriptRunLogger;
import java.util.OptionalInt;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.openzen.zencode.java.logger.ScriptingEngineLogger;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.validator.ValidationLogEntry;

sealed class ScriptRunLogger
implements ScriptingEngineLogger
permits GameTestScriptRunLogger {
    private final Logger logger;
    private final Function<SourceFile, OptionalInt> priority;

    ScriptRunLogger(Logger logger, Function<SourceFile, OptionalInt> priorityGetter) {
        this.logger = logger;
        this.priority = priorityGetter;
    }

    @Override
    public void logCompileException(CompileException exception) {
        this.logger.error("Error while compiling scripts: ", (Throwable)exception);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public void debug(String message) {
        this.logger.debug(message);
    }

    @Override
    public void trace(String message) {
        this.logger.trace(message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(message);
    }

    @Override
    public void error(String message) {
        this.logger.error(message);
    }

    @Override
    public void throwingErr(String message, Throwable throwable) {
        this.logger.error("Error while running scripts:", throwable);
    }

    @Override
    public void throwingWarn(String message, Throwable throwable) {
        this.logger.warn("Warning while running scripts:", throwable);
    }

    @Override
    public void logSourceFile(SourceFile file) {
        this.logger.info("Loading file '{}'{}", (Object)file.getFilename(), (Object)this.priority.apply(file).stream().mapToObj(it -> " with priority " + it).findFirst().orElse(""));
    }

    @Override
    public void logValidationError(ValidationLogEntry errorEntry) {
        this.logger.error("{}: {}", (Object)errorEntry.position, (Object)errorEntry.message);
    }

    @Override
    public void logValidationWarning(ValidationLogEntry warningEntry) {
        this.logger.warn("{}: {}", (Object)warningEntry.position, (Object)warningEntry.message);
    }
}

