/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.entity.attribute.ExpandAttribute;
import com.blamejared.crafttweaker.natives.entity.equipment.ExpandEquipmentSlot;
import com.blamejared.crafttweaker.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.util.TriConsumer;

public final class HandCommands {
    private HandCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("hand", Component.translatable((String)"crafttweaker.command.description.hand"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            Item item = stack.getItem();
            HandCommands.sendBasicItemInformation(source, stack);
            if (item instanceof BlockItem) {
                HandCommands.sendBlockInformation(source, (BlockItem)stack.getItem());
            }
            if (item instanceof BucketItem && Services.PLATFORM.getBucketContent((BucketItem)item) != Fluids.EMPTY) {
                HandCommands.sendBucketInformation(source, (BucketItem)stack.getItem());
            }
            for (MutableComponent component : Services.PLATFORM.getFluidsForDump(stack, (Player)player, InteractionHand.MAIN_HAND)) {
                HandCommands.sendHand(source, Component.translatable((String)"crafttweaker.command.misc.fluid"), component.getString());
            }
            HandCommands.sendTagsInformation(source, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "registry_name", Component.translatable((String)"crafttweaker.command.description.hand.registryname"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ItemStack mainHandItem = source.getPlayerOrException().getMainHandItem();
            HandCommands.sendCopyingHand(source, Component.translatable((String)"crafttweaker.command.misc.item"), BuiltInRegistries.ITEM.getKey((Object)mainHandItem.getItem()).toString());
            return 1;
        }));
        handler.registerSubCommand("hand", "data", Component.translatable((String)"crafttweaker.command.description.hand.data"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            if (!stack.has(DataComponents.CUSTOM_DATA)) {
                CommandUtilities.send(source, (Component)Component.translatable((String)"crafttweaker.command.hand.no.data"));
                return 0;
            }
            HandCommands.sendCopyingHand(source, Component.translatable((String)"crafttweaker.command.misc.data"), new MapData(((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe()).accept(new DataToTextComponentVisitor(" ", 0)).getString());
            return 1;
        }));
        handler.registerSubCommand("hand", "tags", Component.translatable((String)"crafttweaker.command.description.hand.tags"), builder -> builder.executes(context -> {
            ServerPlayer player;
            ItemStack stack;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Collection<String> tags = HandCommands.sendTagsInformation(source, (stack = (player = source.getPlayerOrException()).getMainHandItem()).getItem());
            if (tags.isEmpty()) {
                CommandUtilities.send(source, (Component)Component.translatable((String)"crafttweaker.command.hand.no.tags"));
                return 1;
            }
            tags.stream().findFirst().ifPresent(it -> CommandUtilities.copy(source, it));
            return 1;
        }));
        handler.registerSubCommand("hand", "vanilla", Component.translatable((String)"crafttweaker.command.description.hand.vanilla"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            Item item = stack.getItem();
            HandCommands.sendBasicVanillaItemInformation(source, stack);
            if (stack.has(DataComponents.CUSTOM_DATA)) {
                HandCommands.sendVanillaDataInformation(source, (Tag)((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe());
            }
            if (item instanceof BucketItem && Services.PLATFORM.getBucketContent((BucketItem)item) != Fluids.EMPTY) {
                HandCommands.sendVanillaBucketInformation(source, (BucketItem)stack.getItem());
            }
            HandCommands.sendVanillaTagsInformation(source, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "attributes", Component.translatable((String)"crafttweaker.command.description.hand.attributes"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.getPlayerOrException();
            ItemStack stack = player.getMainHandItem();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                String commandString = ExpandEquipmentSlot.getCommandString(slot);
                HashMap<Attribute, List> modifiers = new HashMap<Attribute, List>();
                stack.forEachModifier(slot, (attributeHolder, attributeModifier) -> modifiers.computeIfAbsent((Attribute)attributeHolder.value(), attribute -> new ArrayList()).add(attributeModifier));
                if (!modifiers.isEmpty()) {
                    CommandUtilities.sendCopying(source, Component.translatable((String)"crafttweaker.command.hand.header.attributes").append(": ").append((Component)Component.literal((String)commandString).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.DARK_AQUA), commandString);
                }
                modifiers.forEach((attribute, attributeModifiers) -> {
                    String attributeCS = ExpandAttribute.getCommandString(attribute);
                    CommandUtilities.sendCopying(source, Component.literal((String)"- ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)attributeCS).withStyle(ChatFormatting.GREEN)), attributeCS);
                    attributeModifiers.forEach(attributeModifier -> {
                        HandCommands.sendAttributePropertyInformation(source, "ID", attributeModifier.id().toString());
                        HandCommands.sendAttributePropertyInformation(source, "Operation", attributeModifier.operation().name());
                        HandCommands.sendAttributePropertyInformation(source, "Amount", String.valueOf(attributeModifier.amount()));
                        HandCommands.sendAttributePropertyInformation(source, "IData", new MapData(attributeModifier.save()).asString());
                    });
                });
            }
            HandCommands.sendCopyingHand(source, Component.translatable((String)"crafttweaker.command.misc.item"), BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString());
            return 1;
        }));
    }

    private static void sendBasicItemInformation(CommandSourceStack source, ItemStack target) {
        String output = ItemStackUtil.getCommandString(target);
        HandCommands.sendCopyingHand(source, Component.translatable((String)"crafttweaker.command.misc.item"), output);
    }

    private static void sendBlockInformation(CommandSourceStack source, BlockItem target) {
        HandCommands.sendBlockInformation(source, target.getBlock());
    }

    private static void sendBlockInformation(CommandSourceStack source, Block target) {
        HandCommands.sendHand(source, Component.translatable((String)"crafttweaker.command.misc.block"), ExpandBlock.getCommandString(target));
        HandCommands.sendHand(source, Component.translatable((String)"crafttweaker.command.misc.blockstate"), ExpandBlockState.getCommandString(target.defaultBlockState()));
    }

    private static void sendBucketInformation(CommandSourceStack source, BucketItem target) {
        if (Services.PLATFORM.getBucketContent(target) == Fluids.EMPTY) {
            return;
        }
        HandCommands.sendHand(source, Component.translatable((String)"crafttweaker.command.misc.fluidblockstate"), ExpandBlockState.getCommandString(Services.PLATFORM.getBucketContent(target).defaultFluidState().createLegacyBlock()));
    }

    private static Collection<String> sendTagsInformation(CommandSourceStack source, Item item) {
        ArrayList<String> tags = new ArrayList<String>(HandCommands.sendItemTagsInformation(source, item));
        if (item instanceof BlockItem) {
            tags.addAll(HandCommands.sendBlockTagsInformation(source, (BlockItem)item));
        }
        return tags;
    }

    private static Collection<String> sendItemTagsInformation(CommandSourceStack source, Item item) {
        return HandCommands.sendTagsInformation(source, Component.translatable((String)"crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.ITEM), item);
    }

    private static Collection<String> sendBlockTagsInformation(CommandSourceStack source, BlockItem item) {
        return HandCommands.sendTagsInformation(source, Component.translatable((String)"crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.BLOCK), item.getBlock());
    }

    private static <T> Collection<String> sendTagsInformation(CommandSourceStack source, MutableComponent header, KnownTagManager<?> manager, T target) {
        Holder<T> tHolder = Services.REGISTRY.holderOrThrow(manager.resourceKey(), target);
        if (tHolder.tags().findAny().isEmpty()) {
            return List.of();
        }
        CommandUtilities.send(source, (Component)header.withStyle(ChatFormatting.DARK_AQUA));
        return tHolder.tags().map(tTagKey -> new KnownTag(tTagKey.location(), manager)).map(MCTag::getCommandString).peek(it -> HandCommands.sendTagHand(source, it)).toList();
    }

    private static void sendBasicVanillaItemInformation(CommandSourceStack source, ItemStack target) {
        String output = Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)target.getItem())).toString();
        HandCommands.sendCopyingHand(source, Component.translatable((String)"crafttweaker.command.misc.item"), output);
    }

    private static void sendVanillaDataInformation(CommandSourceStack source, Tag nbt) {
        HandCommands.sendHand(source, Component.translatable((String)"crafttweaker.command.misc.data"), nbt.toString());
    }

    private static void sendVanillaBucketInformation(CommandSourceStack source, BucketItem target) {
        if (Services.PLATFORM.getBucketContent(target) == Fluids.EMPTY) {
            return;
        }
        HandCommands.sendHand(source, Component.translatable((String)"crafttweaker.command.misc.fluidblockstate"), BuiltInRegistries.FLUID.getKey((Object)Services.PLATFORM.getBucketContent(target)).toString());
    }

    private static void sendVanillaTagsInformation(CommandSourceStack source, Item item) {
        HandCommands.sendVanillaItemTagsInformation(source, item);
        if (item instanceof BlockItem) {
            HandCommands.sendVanillaBlockTagsInformation(source, (BlockItem)item);
        }
    }

    private static void sendVanillaItemTagsInformation(CommandSourceStack source, Item item) {
        HandCommands.sendVanillaTagsInformation(source, Component.translatable((String)"crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.tagManager(Registries.ITEM), item);
    }

    private static void sendVanillaBlockTagsInformation(CommandSourceStack source, BlockItem item) {
        HandCommands.sendVanillaTagsInformation(source, Component.translatable((String)"crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.tagManager(Registries.BLOCK), item.getBlock());
    }

    private static <T> void sendVanillaTagsInformation(CommandSourceStack source, MutableComponent header, ITagManager<?> manager, T target) {
        Holder<T> tHolder = Services.REGISTRY.holderOrThrow(manager.resourceKey(), target);
        if (tHolder.tags().findAny().isEmpty()) {
            return;
        }
        CommandUtilities.send(source, (Component)header.withStyle(ChatFormatting.DARK_AQUA));
        tHolder.tags().map(tTagKey -> "#" + String.valueOf(tTagKey.location())).forEach(it -> HandCommands.sendTagHand(source, it));
    }

    private static void sendAttributePropertyInformation(CommandSourceStack source, String propertyName, String value) {
        CommandUtilities.sendCopying(source, Component.literal((String)"    - ").append(propertyName).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)value).withStyle(ChatFormatting.AQUA)), value);
    }

    private static void sendHand(CommandSourceStack source, MutableComponent messagePrefix, String target) {
        HandCommands.sendHand(source, messagePrefix, target, (TriConsumer<CommandSourceStack, MutableComponent, String>)((TriConsumer)CommandUtilities::sendCopying));
    }

    private static void sendCopyingHand(CommandSourceStack source, MutableComponent messagePrefix, String target) {
        HandCommands.sendHand(source, messagePrefix, target, (TriConsumer<CommandSourceStack, MutableComponent, String>)((TriConsumer)CommandUtilities::sendCopyingAndCopy));
    }

    private static void sendHand(CommandSourceStack source, MutableComponent messagePrefix, String target, TriConsumer<CommandSourceStack, MutableComponent, String> consumer) {
        consumer.accept((Object)source, (Object)messagePrefix.append(": ").append((Component)Component.literal((String)target).withStyle(ChatFormatting.GREEN)), (Object)target);
    }

    private static void sendTagHand(CommandSourceStack source, String tag) {
        CommandUtilities.sendCopying(source, Component.literal((String)"    ").append((Component)Component.literal((String)"- ").withStyle(ChatFormatting.YELLOW)).append(" ").append((Component)Component.literal((String)tag).withStyle(ChatFormatting.AQUA)), tag);
    }
}

