/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.core.util.ObjectArrayIterator;

public final class HandleUtil {
    private static final MethodHandles.Lookup LOOKUP = HandleUtil.findLookup();

    private HandleUtil() {
    }

    public static MethodHandle linkMethod(Class<?> type, AccessType accessType, String methodName, Class<?> returnType, Class<?> ... arguments) {
        return HandleUtil.linkMethod(type, accessType, Names.of(methodName), returnType, arguments);
    }

    public static MethodHandle linkMethod(Class<?> type, AccessType accessType, Names methodNames, Class<?> returnType, Class<?> ... arguments) {
        int s;
        MethodType signature = MethodType.methodType(returnType, arguments);
        ArrayList<NoSuchMethodException> exceptions = null;
        for (String methodName : methodNames) {
            try {
                String targetName = Services.PLATFORM.findMappedMethodName(type, methodName, returnType, arguments);
                return switch (accessType.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 1 -> LOOKUP.findStatic(type, targetName, signature);
                    case 0 -> LOOKUP.findVirtual(type, targetName, signature);
                };
            }
            catch (NoSuchMethodException e) {
                (exceptions == null ? new ArrayList<NoSuchMethodException>() : exceptions).add(e);
            }
            catch (IllegalAccessException e) {
                throw new UnableToLinkHandleException("Unable to access method " + StringUtil.quoteAndEscape(methodName), e);
            }
        }
        Throwable cause = exceptions == null ? new NullPointerException("No method name specified") : (Throwable)exceptions.get(0);
        UnableToLinkHandleException e = new UnableToLinkHandleException("No method with names " + String.valueOf(methodNames) + " found in target type " + type.getName(), cause);
        int n = s = exceptions == null ? 0 : exceptions.size();
        for (int i = 1; i < s; ++i) {
            e.addSuppressed((Throwable)exceptions.get(i));
        }
        throw e;
    }

    public static VarHandle linkField(Class<?> owner, AccessType accessType, String fieldName, Class<?> type) {
        return HandleUtil.linkField(owner, accessType, Names.of(fieldName), type);
    }

    public static VarHandle linkField(Class<?> owner, AccessType accessType, Names fieldNames, Class<?> type) {
        int s;
        ArrayList<NoSuchFieldException> exceptions = null;
        for (String fieldName : fieldNames) {
            try {
                String targetName = Services.PLATFORM.findMappedFieldName(owner, fieldName, type);
                return switch (accessType.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 1 -> LOOKUP.findStaticVarHandle(owner, targetName, type);
                    case 0 -> LOOKUP.findVarHandle(owner, targetName, type);
                };
            }
            catch (NoSuchFieldException e) {
                (exceptions == null ? new ArrayList<NoSuchFieldException>() : exceptions).add(e);
            }
            catch (IllegalAccessException e) {
                throw new UnableToLinkHandleException("Unable to access field " + StringUtil.quoteAndEscape(fieldName), e);
            }
        }
        Throwable cause = exceptions == null ? new NullPointerException("No method name specified") : (Throwable)exceptions.get(0);
        UnableToLinkHandleException e = new UnableToLinkHandleException("No field with names " + String.valueOf(fieldNames) + " found in target type " + type.getName(), cause);
        int n = s = exceptions == null ? 0 : exceptions.size();
        for (int i = 1; i < s; ++i) {
            e.addSuppressed((Throwable)exceptions.get(i));
        }
        throw e;
    }

    public static <R> R invoke(MethodHandleInvoker<R> invoker) {
        try {
            return invoker.invoke();
        }
        catch (WrongMethodTypeException e) {
            throw new FailedInvocationException("Unable to invoke target handle: check your arguments", e);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException("Invoked handle threw an exception", throwable);
        }
    }

    public static void invokeVoid(MethodHandleVoidInvoker invoker) {
        try {
            invoker.invoke();
        }
        catch (WrongMethodTypeException e) {
            throw new FailedInvocationException("Unable to invoke target handle: check your arguments", e);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException("Invoked handle threw an exception", throwable);
        }
    }

    private static MethodHandles.Lookup findLookup() {
        try {
            Field[] declaredFields;
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandles.Lookup unsafeLookup = MethodHandles.privateLookupIn(unsafeClass, MethodHandles.lookup());
            VarHandle unsafeField = unsafeLookup.findStaticVarHandle(unsafeClass, "theUnsafe", unsafeClass);
            MethodHandle staticFieldBase = unsafeLookup.findVirtual(unsafeClass, "staticFieldBase", MethodType.methodType(Object.class, Field.class));
            MethodHandle staticFieldOffset = unsafeLookup.findVirtual(unsafeClass, "staticFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
            MethodHandle getObject = unsafeLookup.findVirtual(unsafeClass, "getObject", MethodType.methodType(Object.class, Object.class, Long.TYPE));
            Object unsafe = unsafeField.get();
            Class<MethodHandles.Lookup> methodHandlesLookupClass = MethodHandles.Lookup.class;
            for (Field declaredField : declaredFields = methodHandlesLookupClass.getDeclaredFields()) {
                long offset;
                Object base;
                Object lookupObject;
                MethodHandles.Lookup lookup;
                if (declaredField.getType() != MethodHandles.Lookup.class || (lookup = (MethodHandles.Lookup)GenericUtil.uncheck(lookupObject = getObject.invoke(unsafe, base = staticFieldBase.invoke(unsafe, declaredField), offset = staticFieldOffset.invoke(unsafe, declaredField)))).lookupModes() != 127) continue;
                return lookup;
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to find lookup", e);
        }
        throw new IllegalStateException("Unable to find lookup");
    }

    public static final class Names
    implements Iterable<String> {
        private final String[] names;

        private Names(String ... names) {
            this.names = names;
        }

        public static Names of(String ... names) {
            return new Names((String[])Set.of(names).toArray(String[]::new));
        }

        @Override
        public Iterator<String> iterator() {
            return new ObjectArrayIterator((Object[])this.names);
        }

        public String toString() {
            return Arrays.toString(this.names);
        }
    }

    public static enum AccessType {
        VIRTUAL,
        STATIC;

    }

    public static final class UnableToLinkHandleException
    extends RuntimeException {
        private UnableToLinkHandleException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    public static interface MethodHandleInvoker<R> {
        public R invoke() throws Throwable;
    }

    public static final class FailedInvocationException
    extends RuntimeException {
        private FailedInvocationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface MethodHandleVoidInvoker {
        public void invoke() throws Throwable;
    }
}

