/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.tag.expand;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientEmpty;
import com.blamejared.crafttweaker.api.ingredient.type.TagIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tag/ExpandItemTag")
@ZenCodeType.Expansion(value="crafttweaker.api.tag.type.KnownTag<crafttweaker.api.item.ItemDefinition>")
public class ExpandItemTag {
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IIngredient asIIngredient(KnownTag<Item> internal) {
        if (!internal.exists() && !Services.PLATFORM.isDataGen()) {
            CommonLoggers.api().warn("Tag '{}' does not exist, replacing with empty IIngredient", (Object)internal.getCommandString());
            return IIngredientEmpty.INSTANCE;
        }
        return new TagIngredient((TagKey<Item>)internal.getTagKey());
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(KnownTag<Item> internal) {
        return ExpandItemTag.asIIngredient(internal).asIData();
    }

    @ZenCodeType.Method
    public static void add(KnownTag<Item> internal, List<IItemStack> items) {
        internal.add((Item[])((Item[])items.stream().map(IItemStack::getDefinition).toArray(Item[]::new)));
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IIngredientWithAmount asIIngredientWithAmount(KnownTag<Item> _this) {
        IIngredient iIngredient = ExpandItemTag.asIIngredient(_this);
        return iIngredient.asIIngredientWithAmount();
    }
}

