/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.handler.helper;

import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

public final class CraftingTableRecipeConflictChecker {
    public static boolean checkConflicts(IRecipeManager<?> manager, Recipe<?> first, Recipe<?> second) {
        if (first.isSpecial() || second.isSpecial()) {
            return false;
        }
        if (!(first instanceof ShapedRecipe) && second instanceof ShapedRecipe) {
            return CraftingTableRecipeConflictChecker.redirect(manager, second, first);
        }
        return CraftingTableRecipeConflictChecker.checkConflictsMaybeDifferent(first, second);
    }

    private static <T extends Recipe<?>> boolean redirect(IRecipeManager<?> manager, T second, Recipe<?> first) {
        return IRecipeHandlerRegistry.getHandlerFor(second).doesConflict((IRecipeManager)GenericUtil.uncheck(manager), second, first);
    }

    private static boolean checkConflictsMaybeDifferent(Recipe<?> first, Recipe<?> second) {
        if (first instanceof ShapedRecipe) {
            ShapedRecipe shapedFirst = (ShapedRecipe)first;
            if (second instanceof ShapedRecipe) {
                ShapedRecipe shapedSecond = (ShapedRecipe)second;
                return CraftingTableRecipeConflictChecker.doShapedShapedConflict(shapedFirst, shapedSecond);
            }
            return CraftingTableRecipeConflictChecker.doShapedShapelessConflict(shapedFirst, second);
        }
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first, second);
    }

    private static boolean doShapedShapedConflict(ShapedRecipe first, ShapedRecipe second) {
        if (first.getHeight() != second.getHeight()) {
            return false;
        }
        if (first.getWidth() != second.getWidth()) {
            return false;
        }
        NonNullList firstIngredients = first.getIngredients();
        NonNullList secondIngredients = second.getIngredients();
        for (int i = 0; i < firstIngredients.size(); ++i) {
            Ingredient secondIngredient;
            Ingredient firstIngredient = (Ingredient)firstIngredients.get(i);
            if (IngredientUtil.canConflict(firstIngredient, secondIngredient = (Ingredient)secondIngredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean doShapedShapelessConflict(ShapedRecipe first, Recipe<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict(first.getIngredients().stream().filter(it -> it != Ingredient.EMPTY).collect(Collectors.toList()), (List<Ingredient>)second.getIngredients());
    }

    private static boolean doShapelessShapelessConflict(Recipe<?> first, Recipe<?> second) {
        return CraftingTableRecipeConflictChecker.doShapelessShapelessConflict((List<Ingredient>)first.getIngredients(), (List<Ingredient>)second.getIngredients());
    }

    private static boolean doShapelessShapelessConflict(List<Ingredient> first, List<Ingredient> second) {
        if (first.size() != second.size()) {
            return false;
        }
        return IngredientUtil.doIngredientsConflict(first, second);
    }
}

