/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.model;

import java.util.HashMap;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2960;
import net.minecraft.class_4942;
import net.minecraft.class_4945;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.mixin.ModelAccessor;
import pers.solid.brrp.v1.model.ModelJsonBuilder;

@PreferredEnvironment(value=EnvType.CLIENT)
public final class ModelUtils {
    private ModelUtils() {
    }

    @Contract(pure=true)
    public static class_2960 getId(@NotNull class_4942 model) {
        return ((ModelAccessor)model).getParent().orElse(null);
    }

    @Contract(pure=true)
    @NotNull
    public static class_2960 appendVariant(@NotNull class_2960 modelId, @NotNull class_4942 model) {
        return ((ModelAccessor)model).getVariant().map(arg_0 -> modelId.brrp_suffixed(arg_0)).orElse(modelId);
    }

    @Contract(pure=true, value="_, _ -> new")
    public static HashMap<String, String> getTextureMap(BlockResourceGenerator blockResourceGenerator, class_4945 ... textureKeys) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (class_4945 textureKey : textureKeys) {
            map.put(textureKey.method_25912(), blockResourceGenerator.getTextureId(textureKey).toString());
        }
        return map;
    }

    @Contract(mutates="param1")
    public static void writeModelsWithVariants(@NotNull RuntimeResourcePack pack, @NotNull class_2960 modelId, @NotNull ModelJsonBuilder model, class_4942 parent) {
        pack.addModel(ModelUtils.appendVariant(modelId, parent), model.withParent(parent));
    }

    @Contract(mutates="param1")
    public static void writeModelsWithVariants(@NotNull RuntimeResourcePack pack, @NotNull class_2960 modelId, @NotNull ModelJsonBuilder model, class_4942 ... parents) {
        for (class_4942 parent : parents) {
            ModelUtils.writeModelsWithVariants(pack, modelId, model, parent);
        }
    }

    @NotNull
    @Contract(value="_, _ -> new", pure=true)
    public static ModelJsonBuilder createModelWithVariants(BlockResourceGenerator blockResourceGenerator, class_4942 parent) {
        ModelJsonBuilder model = ModelJsonBuilder.create(parent);
        for (class_4945 textureKey : ((ModelAccessor)parent).getRequiredTextures()) {
            model.addTexture(textureKey, blockResourceGenerator.getTextureId(textureKey));
        }
        return model;
    }
}

