/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_793;
import net.minecraft.class_811;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.mixin.TextureMapAccessor;
import pers.solid.brrp.v1.model.ModelElementBuilder;
import pers.solid.brrp.v1.model.ModelOverrideBuilder;
import pers.solid.brrp.v1.model.ModelUtils;
import pers.solid.brrp.v1.model.TransformationBuilder;

public class ModelJsonBuilder
implements Cloneable {
    public List<ModelElementBuilder> elements;
    @SerializedName(value="gui_light")
    public GuiLight guiLight;
    @SerializedName(value="ambientocclusion")
    public Boolean ambientOcclusion;
    @SerializedName(value="display")
    public Map<class_811, TransformationBuilder> transformations;
    public List<ModelOverrideBuilder> overrides;
    public Map<String, String> textures;
    @SerializedName(value="parent")
    public class_2960 parentId;

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static ModelJsonBuilder create(class_2960 parentId) {
        ModelJsonBuilder modelJsonBuilder = new ModelJsonBuilder();
        modelJsonBuilder.parentId = parentId;
        return modelJsonBuilder;
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static ModelJsonBuilder create(String parentId) {
        return ModelJsonBuilder.create(class_2960.method_60654((String)parentId));
    }

    @NotNull
    @Contract(pure=true, value="_ -> new")
    public static ModelJsonBuilder create(class_4942 parentModel) {
        return ModelJsonBuilder.create(ModelUtils.getId(parentModel));
    }

    @NotNull
    @Contract(pure=true, value="_, _ -> new")
    public static ModelJsonBuilder create(String namespace, String path) {
        return ModelJsonBuilder.create(class_2960.method_60655((String)namespace, (String)path));
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setOverrides(List<ModelOverrideBuilder> overrides) {
        this.overrides = overrides;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder addOverride(ModelOverrideBuilder override) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<ModelOverrideBuilder>();
        }
        this.overrides.add(override);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setElements(List<ModelElementBuilder> elements) {
        this.elements = elements;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder addElement(ModelElementBuilder element) {
        if (this.elements == null) {
            this.elements = new ArrayList<ModelElementBuilder>();
        }
        this.elements.add(element);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder guiLight(GuiLight guiLight) {
        this.guiLight = guiLight;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder ambientOcclusion(Boolean ambientOcclusion) {
        this.ambientOcclusion = ambientOcclusion;
        return this;
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder transformation(class_811 modelTransformationMode, TransformationBuilder transformation) {
        if (this.transformations == null) {
            this.transformations = new LinkedHashMap<class_811, TransformationBuilder>();
        }
        this.transformations.put(modelTransformationMode, transformation);
        return this;
    }

    @Contract(mutates="this", value="_-> this")
    public ModelJsonBuilder transformations(Map<class_811, TransformationBuilder> transformations) {
        this.transformations = transformations;
        return this;
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull class_4945 textureKey, @Nullable class_2960 textureLocation) {
        return this.addTexture(textureKey.method_25912(), textureLocation);
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull class_4945 textureKey, @Nullable String textureReference) {
        return this.addTexture(textureKey.method_25912(), textureReference);
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull String key, @Nullable class_2960 textureLocation) {
        return this.addTexture(key, textureLocation == null ? null : textureLocation.toString());
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder addTexture(@NotNull String key, @Nullable String textureReference) {
        if (this.textures == null) {
            this.textures = new LinkedHashMap<String, String>();
        }
        this.textures.put(key, textureReference);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setTextures(class_4944 textures) {
        ((TextureMapAccessor)textures).getEntries().forEach(this::addTexture);
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder setTextures(Map<String, String> textures) {
        this.textures = textures;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder parent(class_4942 model) {
        return this.parent(ModelUtils.getId(model));
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder parent(class_2960 parentId) {
        this.parentId = parentId;
        return this;
    }

    @Contract(mutates="this", value="_ -> this")
    public ModelJsonBuilder parent(String parentId) {
        return this.parent(class_2960.method_60654((String)parentId));
    }

    @Contract(mutates="this", value="_, _ -> this")
    public ModelJsonBuilder parent(String namespace, String path) {
        return this.parent(class_2960.method_60655((String)namespace, (String)path));
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(class_4942 model) {
        return this.withParent(ModelUtils.getId(model));
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(String namespace, String path) {
        return this.withParent(class_2960.method_60655((String)namespace, (String)path));
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(class_2960 parentId) {
        if (Objects.equals(this.parentId, parentId)) {
            return this;
        }
        return this.clone().parent(parentId);
    }

    @Contract(pure=true)
    public ModelJsonBuilder withParent(String parentId) {
        return this.withParent(class_2960.method_60654((String)parentId));
    }

    public ModelJsonBuilder clone() {
        try {
            ModelJsonBuilder clone = (ModelJsonBuilder)super.clone();
            if (clone.elements != null) {
                clone.elements = new ArrayList<ModelElementBuilder>(this.elements);
            }
            if (clone.overrides != null) {
                clone.overrides = new ArrayList<ModelOverrideBuilder>(this.overrides);
            }
            if (clone.transformations != null) {
                clone.transformations = new HashMap<class_811, TransformationBuilder>(this.transformations);
            }
            if (clone.textures != null) {
                clone.textures = new HashMap<String, String>(this.textures);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static enum GuiLight implements class_3542
    {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String name) {
            this.name = name;
        }

        @Environment(value=EnvType.CLIENT)
        public class_793.class_4751 asVanillaGuiLight() {
            return this == FRONT ? class_793.class_4751.field_21858 : class_793.class_4751.field_21859;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

