/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.gui.RRPConfigScreen;

@Environment(value=EnvType.CLIENT)
public class RegenerateScreen
extends class_437 {
    protected static final class_2561 STATE_REGEN_CLIENT = class_2561.method_43471((String)"brrp.regenerateScreen.state.client");
    protected static final class_2561 STATE_REGEN_SERVER = class_2561.method_43471((String)"brrp.regenerateScreen.state.server");
    protected static final class_2561 STATE_REGEN_ALL = class_2561.method_43471((String)"brrp.regenerateScreen.state.all");
    protected static final class_2561 STATE_IDLE = class_2561.method_43471((String)"brrp.regenerateScreen.state.idle");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BRRP/RegenerateScreen");
    private final class_437 parent;
    private final RuntimeResourcePack pack;
    protected Thread currentThread;
    private class_7842 stateText;
    private class_7940 summaryText;
    private class_4185 onlyRegenClientButton;
    private class_4185 onlyRegenServerButton;
    private class_4185 regenButton;
    private class_4185 interruptButton;
    private class_4185 backButton;

    protected RegenerateScreen(class_437 parent, @NotNull RuntimeResourcePack pack) {
        super((class_2561)class_2561.method_43469((String)"brrp.regenerateScreen.title", (Object[])new Object[]{pack.getDisplayName()}));
        this.parent = parent;
        this.pack = pack;
    }

    public class_2561 method_25435() {
        return super.method_25435().method_27661().method_10852(class_5244.field_33849).method_10852(STATE_IDLE);
    }

    protected void method_25426() {
        super.method_25426();
        this.stateText = new class_7842(10, 25, this.field_22789 - 20, 20, STATE_IDLE, this.field_22793).method_48597().method_46438(0xEEEE66);
        this.summaryText = new class_7940(10, 45, class_5244.field_39003, this.field_22793).method_48981(true).method_48984(this.field_22789 - 20).method_48983(-3355444);
        this.onlyRegenClientButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"brrp.regenerateScreen.onlyRegenClient"), button -> this.regenClientOnly()).method_46434(this.field_22789 / 2 - 100, 90, 200, 20).method_46431();
        this.onlyRegenServerButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"brrp.regenerateScreen.onlyRegenServer"), button -> this.regenServerOnly()).method_46434(this.field_22789 / 2 - 100, 110, 200, 20).method_46431();
        this.regenButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"brrp.regenerateScreen.regenAll"), button -> this.regenAll()).method_46434(this.field_22789 / 2 - 100, 130, 200, 20).method_46431();
        this.method_37063((class_364)this.stateText);
        this.method_37063((class_364)this.summaryText);
        this.method_37063((class_364)this.onlyRegenClientButton);
        this.method_37063((class_364)this.onlyRegenServerButton);
        this.method_37063((class_364)this.regenButton);
        this.interruptButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"brrp.regenerateScreen.interrupt"), button -> {
            if (this.currentThread != null) {
                if (this.currentThread.isAlive()) {
                    LOGGER.warn("Interrupting thread {}!", (Object)this.currentThread);
                }
                this.currentThread.interrupt();
                try {
                    this.currentThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Waiting the thread to finish:", (Throwable)e);
                }
            }
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 48, 200, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"brrp.regenerateScreen.interrupt.tooltip"))).method_46431();
        this.method_37063((class_364)this.interruptButton);
        this.interruptButton.field_22763 = false;
        this.backButton = class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431();
        this.method_37063((class_364)this.backButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        this.summaryText.method_46421(this.field_22789 / 2 - this.summaryText.method_25368() / 2);
        boolean isIdle = this.currentThread == null || !this.currentThread.isAlive();
        this.onlyRegenClientButton.field_22763 = isIdle && this.pack.hasSidedRegenerationCallback(class_3264.field_14188);
        this.onlyRegenServerButton.field_22763 = isIdle && this.pack.hasSidedRegenerationCallback(class_3264.field_14190);
        this.regenButton.field_22763 = isIdle && this.pack.hasRegenerationCallback();
        this.backButton.field_22763 = isIdle;
        boolean bl = this.interruptButton.field_22763 = !isIdle;
        if (isIdle) {
            this.stateText.method_25355(STATE_IDLE);
        }
    }

    private void regenClientOnly() {
        this.currentThread = new Thread(() -> {
            try {
                this.pack.regenerateSided(class_3264.field_14188);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted:", (Throwable)e);
            }
        }, "Regenerate client resources");
        this.stateText.method_25355(STATE_REGEN_CLIENT);
        this.currentThread.start();
    }

    private void regenServerOnly() {
        this.currentThread = new Thread(() -> {
            try {
                this.pack.regenerateSided(class_3264.field_14190);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted:", (Throwable)e);
            }
        }, "Regenerate server data");
        this.stateText.method_25355(STATE_REGEN_SERVER);
        this.currentThread.start();
    }

    private void regenAll() {
        this.currentThread = new Thread(() -> {
            try {
                this.pack.regenerate();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted:", (Throwable)e);
            }
        }, "Regenerate all resources");
        this.stateText.method_25355(STATE_REGEN_ALL);
        this.currentThread.start();
    }

    public void method_25393() {
        super.method_25393();
        this.summaryText.method_25355((class_2561)class_2561.method_43469((String)"brrp.configScreen.summary", (Object[])new Object[]{RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.rootResources.", this.pack.numberOfRootResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.clientResources.", this.pack.numberOfClientResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.serverData.", this.pack.numberOfServerData())}));
    }

    public void method_25419() {
        if (this.currentThread != null && this.currentThread.isAlive()) {
            return;
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

